import { CatalogPlugin } from '../types';

// Exported from the Redux store
export default {
  description: 'Zabbix plugin for Grafana',
  downloads: 35977451,
  hasUpdate: false,
  id: 'alexanderzobnin-zabbix-app',
  info: {
    logos: {
      small: 'https://grafana.com/api/plugins/alexanderzobnin-zabbix-app/versions/4.2.2/logos/small',
      large: 'https://grafana.com/api/plugins/alexanderzobnin-zabbix-app/versions/4.2.2/logos/large',
    },
    keywords: ['zabbix', 'monitoring', 'dashboard'],
  },
  isCore: false,
  isDev: false,
  isEnterprise: false,
  isInstalled: false,
  isDisabled: false,
  isDeprecated: false,
  isPublished: true,
  isManaged: false,
  isPreinstalled: { found: false, withVersion: false },
  latestVersion: '4.2.2',
  name: 'Zabbix',
  orgName: 'Alexander Zobnin',
  popularity: 0.2093,
  publishedAt: '2016-04-06T20:23:41.000Z',
  type: 'app',
  signature: 'valid',
  signatureOrg: 'Alexander Zobnin',
  signatureType: 'community',
  updatedAt: '2021-08-25T15:03:49.000Z',
  version: '4.2.2',
  error: undefined,
  insights: { id: 1, name: 'alexanderzobnin-zabbix-app', version: '4.2.2', insights: [] },
  details: {
    grafanaDependency: '>=8.0.0',
    pluginDependencies: [],
    links: [
      {
        name: 'GitHub',
        url: 'https://github.com/alexanderzobnin/grafana-zabbix',
      },
      {
        name: 'Docs',
        url: 'https://alexanderzobnin.github.io/grafana-zabbix',
      },
      {
        name: 'License',
        url: 'https://github.com/alexanderzobnin/grafana-zabbix/blob/master/LICENSE',
      },
    ],
    readme:
      '<h1>Zabbix plugin for Grafana</h1>\n<p><a href="https://circleci.com/gh/alexanderzobnin/grafana-zabbix" target="_blank"><img src="https://circleci.com/gh/alexanderzobnin/grafana-zabbix.svg?style=svg" alt="CircleCI"></a>\n<a href="https://github.com/alexanderzobnin/grafana-zabbix/releases" target="_blank"><img src="https://badge.fury.io/gh/alexanderzobnin%2Fgrafana-zabbix.svg" alt="Version"></a>\n<a href="https://codecov.io/gh/alexanderzobnin/grafana-zabbix" target="_blank"><img src="https://codecov.io/gh/alexanderzobnin/grafana-zabbix/branch/master/graph/badge.svg" alt="codecov"></a>\n<a href="https://github.com/alexanderzobnin/grafana-zabbix/blob/master/CHANGELOG.md" target="_blank"><img src="https://img.shields.io/badge/change-log-blue.svg?style=flat" alt="Change Log"></a>\n<a href="https://alexanderzobnin.github.io/grafana-zabbix" target="_blank"><img src="https://img.shields.io/badge/docs-latest-red.svg?style=flat" alt="Docs"></a>\n<a href="https://twitter.com/alexanderzobnin" target="_blank"><img src="https://img.shields.io/twitter/url/http/shields.io.svg?style=social&amp;label=Follow" alt="Twitter URL"></a>\n<a href="https://paypal.me/alexanderzobnin/10" target="_blank"><img src="https://img.shields.io/badge/donate-paypal-2c9eda.svg?style=flat&amp;colorA=0b3684" alt="Donate"></a></p>\n<p>Visualize your Zabbix metrics with the leading open source software for time series analytics.</p>\n<p><img src="https://user-images.githubusercontent.com/4932851/53799185-e1cdc700-3f4a-11e9-9cb4-8330f501b32e.png" alt="Dashboard"></p>\n<h2>Features</h2>\n<ul>\n<li>Select multiple metrics <a href="https://alexanderzobnin.github.io/grafana-zabbix/guides/gettingstarted/#multiple-items-on-one-graph" target="_blank">by using Regex</a></li>\n<li>Create interactive and reusable dashboards with <a href="https://alexanderzobnin.github.io/grafana-zabbix/guides/templating/" target="_blank">template variables</a></li>\n<li>Show events on graphs with <a href="http://docs.grafana.org/reference/annotations/" target="_blank">Annotations</a></li>\n<li>Display active problems with Triggers panel</li>\n<li>Transform and shape your data with <a href="https://alexanderzobnin.github.io/grafana-zabbix/reference/functions/" target="_blank">metric processing functions</a> (Avg, Median, Min, Max, Multiply, Summarize, Time shift, Alias)</li>\n<li>Find problems faster with <a href="https://alexanderzobnin.github.io/grafana-zabbix/reference/alerting/" target="_blank">Alerting</a> feature</li>\n<li>Mix metrics from multiple data sources in the same dashboard or even graph</li>\n<li>Discover and share <a href="https://grafana.com/dashboards" target="_blank">dashboards</a> in the official library</li>\n</ul>\n<p>See all features overview and dashboards examples at Grafana-Zabbix <a href="http://play.grafana-zabbix.org" target="_blank">Live demo</a> site.\nVisit <a href="https://grafana.com/plugins" target="_blank">plugins page</a> at <a href="http://grafana.com" target="_blank">grafana.com</a> and check out available Grafana data sources, panels and <a href="https://grafana.com/dashboards?dataSource=alexanderzobnin-zabbix-datasource" target="_blank">dashboards</a>.</p>\n<h2>Installation</h2>\n<p>Install by using <code>grafana-cli</code></p>\n<pre><code class="language-sh">grafana-cli plugins install alexanderzobnin-zabbix-app\n</code></pre>\n<p>Or see more installation options in <a href="https://alexanderzobnin.github.io/grafana-zabbix/installation/" target="_blank">docs</a>.</p>\n<h2>Getting started</h2>\n<p>First, <a href="https://alexanderzobnin.github.io/grafana-zabbix/configuration/" target="_blank">configure</a> Zabbix data source. Then you can create your first dashboard with step-by-step <a href="https://alexanderzobnin.github.io/grafana-zabbix/guides/gettingstarted/" target="_blank">Getting started guide</a>.</p>\n<h2>Documentation</h2>\n<ul>\n<li><a href="https://alexanderzobnin.github.io/grafana-zabbix" target="_blank">About</a></li>\n<li><a href="https://alexanderzobnin.github.io/grafana-zabbix/installation" target="_blank">Installation</a></li>\n<li><a href="https://alexanderzobnin.github.io/grafana-zabbix/guides/gettingstarted" target="_blank">Getting Started</a></li>\n<li><a href="https://alexanderzobnin.github.io/grafana-zabbix/guides/templating" target="_blank">Templating</a></li>\n<li><a href="https://alexanderzobnin.github.io/grafana-zabbix/reference/alerting/" target="_blank">Alerting</a></li>\n<li><a href="https://alexanderzobnin.github.io/grafana-zabbix/reference/functions/" target="_blank">Metric processing functions</a></li>\n</ul>\n<h2>Community Resources, Feedback, and Support</h2>\n<ul>\n<li>Found a bug? Want a new feature? Feel free to open an <a href="https://github.com/alexanderzobnin/grafana-zabbix/issues/new" target="_blank">issue</a>.</li>\n<li>Have a question? You also can open issue, but for questions, it would be better to use <a href="https://community.grafana.com/" target="_blank">Grafana Community</a> portal.</li>\n<li>Need additional support? Contact me for details <a href="mailto:alexanderzobnin@gmail.com" target="_blank">alexanderzobnin@gmail.com</a></li>\n</ul>\n<hr>\n<p>:copyright: 2015-2021 Alexander Zobnin alexanderzobnin@gmail.com</p>\n<p>Licensed under the Apache 2.0 License</p>\n',
    versions: [
      {
        version: '4.2.2',
        createdAt: '2021-08-25T15:03:47.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '4.2.1',
        createdAt: '2021-08-10T19:59:28.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '4.2.0',
        createdAt: '2021-08-10T15:37:58.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '4.1.5',
        createdAt: '2021-05-18T14:52:59.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '4.1.4',
        createdAt: '2021-03-09T14:49:58.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '4.1.3',
        createdAt: '2021-03-05T08:54:12.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '4.1.2',
        createdAt: '2021-01-28T10:15:29.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '4.1.1',
        createdAt: '2020-12-30T11:51:47.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '4.1.0',
        createdAt: '2020-12-28T09:58:47.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '4.0.2',
        createdAt: '2020-11-13T14:34:08.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '4.0.1',
        createdAt: '2020-09-02T15:16:32.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '4.0.0',
        createdAt: '2020-08-26T10:36:59.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.12.4',
        createdAt: '2020-07-28T08:18:12.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.12.3',
        createdAt: '2020-07-17T14:24:28.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.12.2',
        createdAt: '2020-05-28T06:46:27.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.12.1',
        createdAt: '2020-05-25T07:26:13.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.12.0',
        createdAt: '2020-05-21T10:16:59.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.11.0',
        createdAt: '2020-03-23T13:29:01.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.10.5',
        createdAt: '2019-12-26T15:29:46.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.10.4',
        createdAt: '2019-08-08T10:11:23.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.10.3',
        createdAt: '2019-07-26T11:59:53.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.10.2',
        createdAt: '2019-04-23T17:23:44.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.10.1',
        createdAt: '2019-03-05T12:17:20.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.10.0',
        createdAt: '2019-02-15T11:20:40.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.9.1',
        createdAt: '2018-05-03T08:49:25.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.9.0',
        createdAt: '2018-03-23T16:37:53.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.8.1',
        createdAt: '2017-12-21T09:30:44.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.8.0',
        createdAt: '2017-12-20T14:23:50.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.7.0',
        createdAt: '2017-10-24T11:57:08.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.6.1',
        createdAt: '2017-07-26T16:23:09.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.6.0',
        createdAt: '2017-07-26T15:30:18.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.5.1',
        createdAt: '2017-07-10T09:47:25.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.5.0',
        createdAt: '2017-07-05T16:58:20.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.4.0',
        createdAt: '2017-05-17T13:48:12.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.3.0',
        createdAt: '2017-02-10T15:50:27.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.2.1',
        createdAt: '2017-02-02T14:20:53.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.2.0',
        createdAt: '2016-12-20T18:25:36.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.1.2',
        createdAt: '2016-11-09T19:12:05.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.1.1',
        createdAt: '2016-09-27T18:05:38.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.1.0',
        createdAt: '2016-09-26T19:31:45.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.0.0',
        createdAt: '2016-07-04T21:17:55.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.0.0-beta8',
        createdAt: '2016-05-02T08:55:24.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.0.0-beta7',
        createdAt: '2016-04-14T18:58:43.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.0.0-beta6',
        createdAt: '2016-04-14T01:10:31.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.0.0-beta5',
        createdAt: '2016-04-12T14:55:31.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.0.0-beta4',
        createdAt: '2016-04-10T21:55:49.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
      {
        version: '3.0.0-beta3',
        createdAt: '2016-04-06T20:23:41.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
      },
    ],
  },
} as CatalogPlugin;

export const datasourcePlugin = {
  description: 'Use Amazon Redshift in Grafana',
  downloads: 3019577,
  id: 'grafana-redshift-datasource',
  info: {
    logos: {
      small: 'https://grafana.com/api/plugins/grafana-redshift-datasource/versions/1.20.0/logos/small',
      large: 'https://grafana.com/api/plugins/grafana-redshift-datasource/versions/1.20.0/logos/large',
    },
    keywords: ['datasource', 'redshift', 'aws', 'amazon', 'cloud provider', 'database', 'data warehouse', 'sql'],
  },
  name: 'Amazon Redshift',
  orgName: 'Grafana Labs',
  popularity: 0.2146,
  publishedAt: '2021-11-24T08:37:47.000Z',
  signature: 'valid',
  signatureOrg: 'Grafana Labs',
  signatureType: 'grafana',
  updatedAt: '2025-01-10T20:23:27.000Z',
  installedVersion: '1.20.0',
  hasUpdate: false,
  isInstalled: true,
  isDisabled: false,
  isCore: false,
  isPublished: true,
  isDeprecated: false,
  isDev: false,
  isEnterprise: false,
  isManaged: false,
  isPreinstalled: {
    found: false,
    withVersion: false,
  },
  type: 'datasource',
  accessControl: {
    'plugins.app:access': true,
    'plugins:write': true,
  },
  angularDetected: false,
  isFullyInstalled: true,
  latestVersion: '1.20.0',
  insights: { id: 2, name: 'grafana-redshift-datasource', version: '1.20.0', insights: [] },
  details: {
    grafanaDependency: '>=8.0.0',
    pluginDependencies: [],
    links: [
      {
        name: 'Website',
        url: 'https://github.com/grafana/redshift-datasource',
      },
      {
        name: 'License',
        url: 'https://github.com/redshift-datasource/blob/master/LICENSE',
      },
    ],
    readme:
      '<h2>Grafana 10 breaking change: update Redshift datasource plugin to &gt;=1.8.3</h2>\n<p>Grafana 10.0.0 was shipped with the new React 18 upgrade. Changes in batching of state updates in React 18 cause a bug in the query editor in Redshift versions &lt;=1.8.2 If you’re using Grafana@&gt;=10.0.0, please update your plugin to version 1.8.3 or higher in your Grafana instance management console.</p>\n<h1>Redshift data source for Grafana</h1>\n<p>The Redshift data source plugin allows you to query and visualize Redshift data metrics from within Grafana.</p>\n<p>This topic explains options, variables, querying, and other options specific to this data source. Refer to <a href="https://grafana.com/docs/grafana/latest/datasources/add-a-data-source/">Add a data source</a> for instructions on how to add a data source to Grafana.</p>\n<h2>Configure the data source in Grafana</h2>\n<p>To access data source settings, hover your mouse over the <strong>Configuration</strong> (gear) icon, then click <strong>Data Sources</strong>, and then click the Amazon Redshift data source.</p>\n<table>\n<thead>\n<tr>\n<th>Name</th>\n<th>Description</th>\n</tr>\n</thead>\n<tbody><tr>\n<td><code>Name</code></td>\n<td>The data source name. This is how you refer to the data source in panels and queries.</td>\n</tr>\n<tr>\n<td><code>Default</code></td>\n<td>Default data source means that it will be pre-selected for new panels.</td>\n</tr>\n<tr>\n<td><code>Authentication Provider</code></td>\n<td>Specify the provider to get credentials.</td>\n</tr>\n<tr>\n<td><code>Access Key ID</code></td>\n<td>If <code>Access &amp; secret key</code> is selected, specify the Access Key of the security credentials to use.</td>\n</tr>\n<tr>\n<td><code>Secret Access Key</code></td>\n<td>If <code>Access &amp; secret key</code> is selected, specify the Secret Key of the security credentials to use.</td>\n</tr>\n<tr>\n<td><code>Credentials Profile Name</code></td>\n<td>Specify the name of the profile to use (if you use <code>~/.aws/credentials</code> file), leave blank for default.</td>\n</tr>\n<tr>\n<td><code>Assume Role Arn</code> (optional)</td>\n<td>Specify the ARN of the role to assume.</td>\n</tr>\n<tr>\n<td><code>External ID</code> (optional)</td>\n<td>If you are assuming a role in another account, that has been created with an external ID, specify the external ID here.</td>\n</tr>\n<tr>\n<td><code>Endpoint</code> (optional)</td>\n<td>Optionally, specify a custom endpoint for the service.</td>\n</tr>\n<tr>\n<td><code>Default Region</code></td>\n<td>Region in which the cluster is deployed.</td>\n</tr>\n<tr>\n<td><code>AWS Secrets Manager</code></td>\n<td>To authenticate with Amazon Redshift using AWS Secrets Manager.</td>\n</tr>\n<tr>\n<td><code>Temporary credentials</code></td>\n<td>To authenticate with Amazon Redshift using temporary database credentials.</td>\n</tr>\n<tr>\n<td><code>Serverless</code></td>\n<td>To use a Redshift Serverless workgroup.</td>\n</tr>\n<tr>\n<td><code>Cluster Identifier</code></td>\n<td>Redshift Provisioned Cluster to use (automatically set if using AWS Secrets Manager).</td>\n</tr>\n<tr>\n<td><code>Workgroup</code></td>\n<td>Redshift Serverless Workgroup to use.</td>\n</tr>\n<tr>\n<td><code>Managed Secret</code></td>\n<td>When using AWS Secrets Manager, select the secret containing the credentials to access the database. Note that Provisioned and Serverless stores credentials in a different format. Refer to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api-access.html#data-api-secrets">Storing database credentials in AWS Secrets Manager</a> for instructions.</td>\n</tr>\n<tr>\n<td><code>Database User</code></td>\n<td>User of the database. Automatically set if using AWS Secrets Manager.</td>\n</tr>\n<tr>\n<td><code>Database</code></td>\n<td>Name of the database within the cluster or workgroup.</td>\n</tr>\n<tr>\n<td><code>Send events to Amazon EventBridge</code></td>\n<td>To send Data API events to Amazon EventBridge for monitoring purpose.</td>\n</tr>\n</tbody></table>\n<h2>Authentication</h2>\n<p>For authentication options and configuration details, see <a href="https://grafana.com/docs/grafana/next/datasources/aws-cloudwatch/aws-authentication/">AWS authentication</a> topic.</p>\n<h3>IAM policies</h3>\n<p>Grafana needs permissions granted via IAM to be able to read Redshift metrics. You can attach these permissions to IAM roles and utilize Grafana&#39;s built-in support for assuming roles. Note that you will need to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_create.html">configure the required policy</a> before adding the data source to Grafana. <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.managed-policies">You can check some predefined policies by AWS here</a>.</p>\n<p>Here is a minimal policy example:</p>\n<pre><code class="language-json">{\n  &quot;Version&quot;: &quot;2012-10-17&quot;,\n  &quot;Statement&quot;: [\n    {\n      &quot;Sid&quot;: &quot;AllowReadingMetricsFromRedshift&quot;,\n      &quot;Effect&quot;: &quot;Allow&quot;,\n      &quot;Action&quot;: [\n        &quot;redshift-data:ListTables&quot;,\n        &quot;redshift-data:DescribeTable&quot;,\n        &quot;redshift-data:GetStatementResult&quot;,\n        &quot;redshift-data:DescribeStatement&quot;,\n        &quot;redshift-data:ListStatements&quot;,\n        &quot;redshift-data:ListSchemas&quot;,\n        &quot;redshift-data:ExecuteStatement&quot;,\n        &quot;redshift-data:CancelStatement&quot;,\n        &quot;redshift:GetClusterCredentials&quot;,\n        &quot;redshift:DescribeClusters&quot;,\n        &quot;redshift-serverless:ListWorkgroups&quot;,\n        &quot;redshift-serverless:GetCredentials&quot;,\n        &quot;secretsmanager:ListSecrets&quot;\n      ],\n      &quot;Resource&quot;: &quot;*&quot;\n    },\n    {\n      &quot;Sid&quot;: &quot;AllowReadingRedshiftQuerySecrets&quot;,\n      &quot;Effect&quot;: &quot;Allow&quot;,\n      &quot;Action&quot;: [&quot;secretsmanager:GetSecretValue&quot;],\n      &quot;Resource&quot;: &quot;*&quot;,\n      &quot;Condition&quot;: {\n        &quot;Null&quot;: {\n          &quot;secretsmanager:ResourceTag/RedshiftQueryOwner&quot;: &quot;false&quot;\n        }\n      }\n    }\n  ]\n}\n</code></pre>\n<h2>Query Redshift data</h2>\n<p>The provided query editor is a standard SQL query editor. Grafana includes some macros to help with writing more complex timeseries queries.</p>\n<h4>Macros</h4>\n<table>\n<thead>\n<tr>\n<th>Macro</th>\n<th>Description</th>\n<th>Output example</th>\n</tr>\n</thead>\n<tbody><tr>\n<td><code>$__timeEpoch(column)</code></td>\n<td><code>$__timeEpoch</code> will be replaced by an expression to convert to a UNIX timestamp and rename the column to time</td>\n<td><code>UNIX_TIMESTAMP(dateColumn) as &quot;time&quot;</code></td>\n</tr>\n<tr>\n<td><code>$__timeFilter(column)</code></td>\n<td><code>$__timeFilter</code> creates a conditional that filters the data (using <code>column</code>) based on the time range of the panel</td>\n<td><code>time BETWEEN &#39;2017-07-18T11:15:52Z&#39; AND &#39;2017-07-18T11:15:52Z&#39;</code></td>\n</tr>\n<tr>\n<td><code>$__timeFrom()</code></td>\n<td><code>$__timeFrom</code> outputs the current starting time of the range of the panel with quotes</td>\n<td><code>&#39;2017-07-18T11:15:52Z&#39;</code></td>\n</tr>\n<tr>\n<td><code>$__timeTo()</code></td>\n<td><code>$__timeTo</code> outputs the current ending time of the range of the panel with quotes</td>\n<td><code>&#39;2017-07-18T11:15:52Z&#39;</code></td>\n</tr>\n<tr>\n<td><code>$__timeGroup(column, &#39;1m&#39;)</code></td>\n<td><code>$__timeGroup</code> groups timestamps so that there is only 1 point for every period on the graph</td>\n<td><code>floor(extract(epoch from time)/60)*60 AS &quot;time&quot;</code></td>\n</tr>\n<tr>\n<td><code>$__schema</code></td>\n<td><code>$__schema</code> uses the selected schema</td>\n<td><code>public</code></td>\n</tr>\n<tr>\n<td><code>$__table</code></td>\n<td><code>$__table</code> outputs a table from the given <code>$__schema</code> (it uses the <code>public</code> schema by default)</td>\n<td><code>sales</code></td>\n</tr>\n<tr>\n<td><code>$__column</code></td>\n<td><code>$__column</code> outputs a column from the current <code>$__table</code></td>\n<td><code>date</code></td>\n</tr>\n<tr>\n<td><code>$__unixEpochFilter(column)</code></td>\n<td><code>$__unixEpochFilter</code> be replaced by a time range filter using the specified column name with times represented as Unix timestamp</td>\n<td><code>column &gt;= 1624406400 AND column &lt;= 1624410000</code></td>\n</tr>\n<tr>\n<td><code>$__unixEpochGroup(column)</code></td>\n<td><code>$__unixEpochGroup</code> is the same as $__timeGroup but for times stored as Unix timestamp</td>\n<td><code>floor(time/60)*60 AS &quot;time&quot;</code></td>\n</tr>\n</tbody></table>\n<h4>Table Visualization</h4>\n<p>Most queries in Redshift will be best represented by a table visualization. Any query will display data in a table. If it can be queried, then it can be put in a table.</p>\n<p>This example returns results for a table visualization:</p>\n<pre><code class="language-sql">SELECT {column_1}, {column_2} FROM {table};\n</code></pre>\n<h4>Timeseries / Graph visualizations</h4>\n<p>For timeseries / graph visualizations, there are a few requirements:</p>\n<ul>\n<li>A column with a <code>date</code> or <code>datetime</code> type must be selected</li>\n<li>The <code>date</code> column must be in ascending order (using <code>ORDER BY column ASC</code>)</li>\n<li>A numeric column must also be selected</li>\n</ul>\n<p>To make a more reasonable graph, be sure to use the <code>$__timeFilter</code> and <code>$__timeGroup</code> macros.</p>\n<p>Example timeseries query:</p>\n<pre><code class="language-sql">SELECT\n  avg(execution_time) AS average_execution_time,\n  $__timeGroup(start_time, &#39;hour&#39;),\n  query_type\nFROM\n  account_usage.query_history\nWHERE\n  $__timeFilter(start_time)\ngroup by\n  query_type,start_time\norder by\n  start_time,query_type ASC;\n</code></pre>\n<h5>Fill value</h5>\n<p>When data frames are formatted as time series, you can choose how missing values should be filled. This in turn affects how they are rendered: with connected or disconnected values. To configure this value, change the &quot;Fill Value&quot; in the query editor.</p>\n<h4>Inspecting the query</h4>\n<p>Because Grafana supports macros that Redshift does not, the fully rendered query, which can be copy/pasted directly into Redshift, is visible in the Query Inspector. To view the full interpolated query, click the Query Inspector button, and the full query will be visible under the &quot;Query&quot; tab.</p>\n<h3>Templates and variables</h3>\n<p>To add a new Redshift query variable, refer to <a href="https://grafana.com/docs/grafana/latest/variables/variable-types/add-query-variable/">Add a query variable</a>. Use your Redshift data source as your data source for the following available queries:</p>\n<p>Any value queried from a Redshift table can be used as a variable. Be sure to avoid selecting too many values, as this can cause performance issues.</p>\n<p>To display a custom display name for a variable, you can use a query such as <code>SELECT hostname AS text, id AS value FROM MyTable</code>. In this case the variable value field must be a string type or cast to a string type.</p>\n<p>After creating a variable, you can use it in your Redshift queries by using <a href="https://grafana.com/docs/grafana/latest/variables/syntax/">Variable syntax</a>. For more information about variables, refer to <a href="https://grafana.com/docs/grafana/latest/variables/">Templates and variables</a>.</p>\n<h3>Annotations</h3>\n<p><a href="https://grafana.com/docs/grafana/latest/dashboards/annotations/">Annotations</a> allow you to overlay rich event information on top of graphs. You can add annotations by clicking on panels or by adding annotation queries via the Dashboard menu / Annotations view.</p>\n<p><strong>Example query to automatically add annotations:</strong></p>\n<pre><code class="language-sql">SELECT\n  time as time,\n  environment as tags,\n  humidity as text\nFROM\n  $__table\nWHERE\n  $__timeFilter(time) and humidity &gt; 95\n</code></pre>\n<p>The following table represents the values of the columns taken into account to render annotations:</p>\n<table>\n<thead>\n<tr>\n<th>Name</th>\n<th>Description</th>\n</tr>\n</thead>\n<tbody><tr>\n<td><code>time</code></td>\n<td>The name of the date/time field. Could be a column with a native SQL date/time data type or epoch value.</td>\n</tr>\n<tr>\n<td><code>timeend</code></td>\n<td>Optional name of the end date/time field. Could be a column with a native SQL date/time data type or epoch value. (Grafana v6.6+)</td>\n</tr>\n<tr>\n<td><code>text</code></td>\n<td>Event description field.</td>\n</tr>\n<tr>\n<td><code>tags</code></td>\n<td>Optional field name to use for event tags as a comma separated string.</td>\n</tr>\n</tbody></table>\n<h2>Provision Redshift data source</h2>\n<p>You can configure the Redshift data source using configuration files with Grafana&#39;s provisioning system. For more information, refer to the <a href="https://grafana.com/docs/grafana/latest/administration/provisioning/">provisioning docs page</a>.</p>\n<p>Here are some provisioning examples.</p>\n<h3>Using AWS SDK (default)</h3>\n<pre><code class="language-yaml">apiVersion: 1\ndatasources:\n  - name: Redshift\n    type: redshift\n    jsonData:\n      authType: default\n      defaultRegion: eu-west-2\n</code></pre>\n<h3>Using credentials&#39; profile name (non-default)</h3>\n<pre><code class="language-yaml">apiVersion: 1\n\ndatasources:\n  - name: Redshift\n    type: redshift\n    jsonData:\n      authType: credentials\n      defaultRegion: eu-west-2\n      profile: secondary\n</code></pre>\n<h3>Using <code>accessKey</code> and <code>secretKey</code></h3>\n<pre><code class="language-yaml">apiVersion: 1\n\ndatasources:\n  - name: Redshift\n    type: grafana-redshift-datasource\n    jsonData:\n      authType: keys\n      defaultRegion: eu-west-2\n    secureJsonData:\n      accessKey: &#39;&lt;your access key&gt;&#39;\n      secretKey: &#39;&lt;your secret key&gt;&#39;\n</code></pre>\n<h3>Using AWS SDK Default and ARN of IAM Role to Assume</h3>\n<pre><code class="language-yaml">apiVersion: 1\ndatasources:\n  - name: Redshift\n    type: grafana-redshift-datasource\n    jsonData:\n      authType: default\n      assumeRoleArn: arn:aws:iam::123456789012:root\n      defaultRegion: eu-west-2\n</code></pre>\n<h2>Pre-configured Redshift dashboards</h2>\n<p>Redshift data source ships with a pre-configured dashboard for some advanced monitoring parameters. This curated dashboard is based on similar dashboards in the <a href="https://github.com/awslabs/amazon-redshift-monitoring">AWS Labs repository for Redshift</a>. Check it out for more details.</p>\n<p>Follow these <a href="https://grafana.com/docs/grafana/latest/dashboards/export-import/#importing-a-dashboard">instructions</a> for importing a dashboard in Grafana.</p>\n<p>Imported dashboards can be found in Configuration &gt; Data Sources &gt; select your Redshift data source &gt; select the Dashboards tab to see available pre-made dashboards.</p>\n<h2>Get the most out of the plugin</h2>\n<ul>\n<li>Add <a href="https://grafana.com/docs/grafana/latest/dashboards/annotations/">Annotations</a>.</li>\n<li>Configure and use <a href="https://grafana.com/docs/grafana/latest/variables/">Templates and variables</a>.</li>\n<li>Add <a href="https://grafana.com/docs/grafana/latest/panels/transformations/">Transformations</a>.</li>\n<li>Set up alerting; refer to <a href="https://grafana.com/docs/grafana/latest/alerting/">Alerts overview</a>.</li>\n</ul>\n<h2>Async Query Data Support</h2>\n<p>Async Query Data support enables an asynchronous query handling flow. With Async Query Data support enabled, queries will be handled over multiple requests (starting, checking its status, and fetching the results) instead of having a query be started and resolved over a single request. This is useful for queries that can potentially run for a long time and timeout. You&#39;ll need to ensure the IAM policy used by Grafana allows the following actions <code>redshift-data:ListStatements</code> and <code>redshift-data:CancelStatement</code>.</p>\n<p>Async query data support is enabled by default in all Redshift datasources.</p>\n<h3>Async Query Caching</h3>\n<p>To enable <a href="https://grafana.com/docs/grafana/latest/administration/data-source-management/#query-caching">query caching</a> for async queries, you need to be on Grafana version 10.1 or above, and to set the feature toggles <code>useCachingService</code> and <code>awsAsyncQueryCaching</code> to <code>true</code>. You&#39;ll also need to <a href="https://grafana.com/docs/grafana/latest/administration/data-source-management/#query-caching">configure query caching</a> for the specific Redshift datasource.</p>\n',
    versions: [
      {
        version: '1.20.0',
        createdAt: '2025-01-10T20:23:26.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.19.1',
        createdAt: '2024-12-06T10:39:33.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.19.0',
        createdAt: '2024-10-21T20:15:45.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.18.0',
        createdAt: '2024-08-20T13:12:42.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.17.0',
        createdAt: '2024-08-12T10:48:02.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.16.0',
        createdAt: '2024-07-05T08:51:15.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.15.2',
        createdAt: '2024-06-26T18:30:12.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.15.1',
        createdAt: '2024-06-10T19:12:04.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.15.0',
        createdAt: '2024-05-31T16:38:26.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.14.0',
        createdAt: '2024-03-19T16:14:51.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.13.3',
        createdAt: '2024-02-16T19:14:40.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.13.2',
        createdAt: '2024-02-12T10:45:23.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.13.1',
        createdAt: '2023-11-24T04:48:20.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.13.0',
        createdAt: '2023-10-31T14:50:23.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.12.2',
        createdAt: '2023-10-05T13:53:53.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.12.1',
        createdAt: '2023-08-30T14:43:16.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.12.0',
        createdAt: '2023-08-23T15:49:16.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.11.1',
        createdAt: '2023-08-15T13:14:00.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.11.0',
        createdAt: '2023-08-08T10:20:47.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.10.0',
        createdAt: '2023-07-19T20:26:45.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.9.0',
        createdAt: '2023-06-20T19:24:48.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.8.4',
        createdAt: '2023-05-15T08:29:05.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.8.3',
        createdAt: '2023-05-10T10:00:53.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.8.2',
        createdAt: '2023-05-05T19:24:43.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.8.1',
        createdAt: '2023-04-25T15:32:50.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.8.0',
        createdAt: '2023-04-20T08:14:30.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.7.0',
        createdAt: '2023-03-02T21:22:15.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.6.0',
        createdAt: '2023-02-01T12:17:23.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.5.0',
        createdAt: '2023-01-25T17:07:23.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.4.1',
        createdAt: '2022-12-05T21:55:26.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.4.0',
        createdAt: '2022-12-02T16:57:08.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.3.3',
        createdAt: '2022-11-30T20:49:43.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.3.2',
        createdAt: '2022-11-04T20:07:33.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.3.1',
        createdAt: '2022-10-24T07:51:39.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.3.0',
        createdAt: '2022-10-04T09:01:57.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.2.0',
        createdAt: '2022-09-22T07:36:27.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.1.0',
        createdAt: '2022-08-24T09:33:58.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.0.7',
        createdAt: '2022-07-21T19:50:20.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.0.6',
        createdAt: '2022-07-12T09:08:36.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.0.5',
        createdAt: '2022-04-01T10:02:36.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.0.4',
        createdAt: '2022-03-24T09:53:08.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.0.3',
        createdAt: '2022-02-22T15:31:54.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.0.2',
        createdAt: '2022-01-25T12:40:17.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.0.1',
        createdAt: '2021-12-01T16:55:29.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '1.0.0',
        createdAt: '2021-11-30T09:16:07.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
      {
        version: '0.4.1',
        createdAt: '2021-11-24T08:43:33.000Z',
        isCompatible: true,
        grafanaDependency: '>=8.0.0',
        angularDetected: false,
      },
    ],
    statusContext: '',
    changelog:
      '<h1>Changelog</h1>\n<h2>1.20.0</h2>\n<ul>\n<li>Add PDC support in <a href="https://github.com/grafana/redshift-datasource/pull/333" target="_blank">#333</a></li>\n<li>Bump node dependencies with 29 updates, ignore react and react-dom major updates in dependabot in <a href="https://github.com/grafana/redshift-datasource/pull/336" target="_blank">#336</a></li>\n<li>Bump the all-go-dependencies group across 1 directory with 3 updates in <a href="https://github.com/grafana/redshift-datasource/pull/335" target="_blank">#335</a></li>\n<li>Add pre-commit hook in <a href="https://github.com/grafana/redshift-datasource/pull/327" target="_blank">#327</a></li>\n</ul>\n<h2>1.19.1</h2>\n<ul>\n<li>Dependabot: Update dependencies in <a href="https://github.com/grafana/redshift-datasource/pull/302" target="_blank">#302</a>, <a href="https://github.com/grafana/redshift-datasource/pull/303" target="_blank">#303</a>, <a href="https://github.com/grafana/redshift-datasource/pull/313" target="_blank">#313</a>,\n<a href="https://github.com/grafana/redshift-datasource/pull/308" target="_blank">#308</a>, <a href="https://github.com/grafana/redshift-datasource/pull/323" target="_blank">#323</a>, <a href="https://github.com/grafana/redshift-datasource/pull/322" target="_blank">#322</a>:\n<ul>\n<li>path-to-regexp from 1.8.0 to 1.9.0 in the npm_and_yarn group</li>\n<li>micromatch from 4.0.5 to 4.0.8 in the npm_and_yarn group</li>\n<li>actions/checkout from 2 to 4</li>\n<li>actions/setup-node from 3 to 4</li>\n<li>tibdex/github-app-token from 1.8.0 to 2.1.0</li>\n<li>github.com/aws/aws-sdk-go from 1.51.31 to 1.55.5</li>\n<li>github.com/grafana/grafana-plugin-sdk-go from 0.254.0 to 0.259.4</li>\n<li>github.com/grafana/grafana-aws-sdk from 0.31.3 to 0.31.4</li>\n<li>github.com/grafana/sqlds/v4 from 4.1.2 to 4.1.4</li>\n<li>braces from 3.0.2 to 3.0.3 in the npm_and_yarn group</li>\n<li>github.com/stretchr/testify from 1.9.0 to 1.10.0(#321)</li>\n<li>@emotion/css 11.13.4 11.13.5</li>\n<li>@grafana/async-query-data from 0.2.0 to 0.3.0</li>\n<li>@grafana/data from 11.2.2 to 11.3.1</li>\n<li>@grafana/experimental from 2.1.2 to 2.1.4</li>\n<li>@grafana/runtime from 11.2.2 to 11.3.1</li>\n<li>tslib from 2.8.0 to 2.8.1</li>\n<li>@babel/core from 7.25.8 to 7.26.0</li>\n<li>@grafana/eslint-config from 7.0.0 to 8.0.0</li>\n<li>@swc/core from 1.7.36 to 1.9.3</li>\n<li>@swc/helpers from 0.5.13 to 0.5.15</li>\n<li>@swc/jest from 0.2.36 to 0.2.37</li>\n<li>@testing-library/jest-dom from 6.6.0 to 6.6.3</li>\n<li>@types/jest from 29.5.13 to 29.5.14</li>\n<li>@types/lodash from 4.17.10 to 4.17.13</li>\n<li>@types/node from 22.7.5 to 22.10.1</li>\n<li>cspell from 8.15.2 to 8.16.1</li>\n<li>cypress from 7.7.0 to 13.16.0</li>\n<li>prettier from 3.3.3 to 3.4.1</li>\n<li>sass from 1.79.5 to 1.81.0</li>\n<li>sass-loader from 16.0.2 to 16.0.3</li>\n<li>typescript from 5.6.3 to 5.7.2</li>\n<li>webpack from 5.95.0 to 5.96.1</li>\n<li>cross-spawn from 7.0.3 to 7.0.6 in the npm_and_yarn group</li>\n</ul></li>\n</ul>\n<h2>1.19.0</h2>\n<ul>\n<li>Chore: update dependencies <a href="https://github.com/grafana/redshift-datasource/pull/300" target="_blank">#300</a></li>\n<li>Chore: bump dependencies <a href="https://github.com/grafana/redshift-datasource/pull/299" target="_blank">#299</a></li>\n<li>Chore: Update plugin.json keywords <a href="https://github.com/grafana/redshift-datasource/pull/298" target="_blank">#298</a></li>\n<li>Add dependabot for grafana/plugin-sdk-go <a href="https://github.com/grafana/redshift-datasource/pull/296" target="_blank">#296</a></li>\n<li>Fix: don\'t check slice nilness before checking length <a href="https://github.com/grafana/redshift-datasource/pull/294" target="_blank">#294</a></li>\n</ul>\n<h2>1.18.0</h2>\n<ul>\n<li>Add errorsource in <a href="https://github.com/grafana/redshift-datasource/pull/292" target="_blank">#292</a></li>\n</ul>\n<h2>1.17.0</h2>\n<ul>\n<li>Update grafana/aws-sdk to get new regions</li>\n</ul>\n<h2>1.16.0</h2>\n<ul>\n<li>Migrate to new form styling in config and query editors in <a href="https://github.com/grafana/redshift-datasource/pull/287" target="_blank">#287</a></li>\n</ul>\n<h2>1.15.2</h2>\n<ul>\n<li>Fix: use ReadAuthSettings to get authSettings in <a href="https://github.com/grafana/redshift-datasource/pull/288" target="_blank">#288</a></li>\n</ul>\n<h2>1.15.1</h2>\n<ul>\n<li>Upgrade grafana-aws-sdk to replace <code>GetSession</code> usages with <code>GetSessionWithAuthSettings</code> <a href="https://github.com/grafana/redshift-datasource/pull/284" target="_blank">#284</a></li>\n</ul>\n<h2>1.15.0</h2>\n<ul>\n<li>Add keywords by @kevinwcyu in https://github.com/grafana/redshift-datasource/pull/273</li>\n<li>Add missing regions and use the region resource handler in the frontend by @iwysiu in https://github.com/grafana/redshift-datasource/pull/276</li>\n<li>Plugin.json: update schema reference URL by @leventebalogh in https://github.com/grafana/redshift-datasource/pull/277</li>\n<li>Fix E2E: Update region before sending the /secrets resource request by @idastambuk in https://github.com/grafana/redshift-datasource/pull/280</li>\n<li>Update for added context in grafana-aws-sdk by @njvrzm in https://github.com/grafana/redshift-datasource/pull/279</li>\n</ul>\n<h2>New Contributors</h2>\n<ul>\n<li>@leventebalogh made their first contribution in https://github.com/grafana/redshift-datasource/pull/277</li>\n<li>@njvrzm made their first contribution in https://github.com/grafana/redshift-datasource/pull/279</li>\n</ul>\n<h2>1.14.0</h2>\n<ul>\n<li>Remove the redshiftAsyncQuerySupport feature toggle + styling improvements in https://github.com/grafana/redshift-datasource/pull/272</li>\n</ul>\n<h2>1.13.3</h2>\n<ul>\n<li>Upgrade @grafana/async-query-data from 0.1.10 to 0.1.11 https://github.com/grafana/redshift-datasource/pull/269</li>\n</ul>\n<h2>1.13.2</h2>\n<ul>\n<li>Update grafana/aws-sdk-go to 0.20.0 https://github.com/grafana/redshift-datasource/pull/268</li>\n</ul>\n<h2>1.13.1</h2>\n<ul>\n<li>Bump go.opentelemetry.io/contrib/instrumentation/net/http/httptrace/otelhttptrace from 0.37.0 to 0.44.0 by @dependabot in https://github.com/grafana/redshift-datasource/pull/257</li>\n<li>Upgrade grafana-plugin-sdk-go; add underscore, debug to package resolutions by @fridgepoet in https://github.com/grafana/redshift-datasource/pull/265</li>\n</ul>\n<p><strong>Full Changelog</strong>: https://github.com/grafana/redshift-datasource/compare/v1.13.0...v1.13.1</p>\n<h2>1.13.0</h2>\n<ul>\n<li>Migrate Query and config editors to new form styling under feature toggle <a href="https://github.com/grafana/redshift-datasource/pull/255" target="_blank">#255</a></li>\n<li>Support Node 18 <a href="https://github.com/grafana/redshift-datasource/pull/249" target="_blank">#249</a></li>\n<li>Fix datasource type in provisioning docs in <a href="https://github.com/grafana/redshift-datasource/pull/246" target="_blank">#246</a></li>\n</ul>\n<h2>1.12.2</h2>\n<ul>\n<li>Fix async queries by not calling ListStatements in GetQueryID <a href="https://github.com/grafana/redshift-datasource/pull/252" target="_blank">#252</a></li>\n</ul>\n<h2>1.12.1</h2>\n<ul>\n<li>upgrade @grafana/aws-sdk to fix a bug in temporary credentials</li>\n</ul>\n<h2>1.12.0</h2>\n<ul>\n<li>Update grafana-aws-sdk to v0.19.1 to add <code>il-central-1</code> to opt-in region list</li>\n</ul>\n<h2>1.11.1</h2>\n<ul>\n<li>Upgrade @grafana/async-query-data to reduce minimum query time https://github.com/grafana/redshift-datasource/pull/237</li>\n</ul>\n<h2>1.11.0</h2>\n<ul>\n<li>Upgrade grafana/aws-sdk-react dependency <a href="https://github.com/grafana/redshift-datasource/pull/236" target="_blank">#239</a></li>\n<li>Fix connection error when changing access and secret key <a href="https://github.com/grafana/redshift-datasource/pull/235" target="_blank">#235</a></li>\n<li>Support async query caching <a href="https://github.com/grafana/redshift-datasource/pull/233" target="_blank">#233</a></li>\n</ul>\n<h2>1.10.0</h2>\n<ul>\n<li>Add support for Redshift Serverless https://github.com/grafana/redshift-datasource/pull/228 by @yota-p</li>\n</ul>\n<h2>1.9.0</h2>\n<ul>\n<li>Upgrade @grafana/aws-sdk to v0.0.47 to support numeric values when applying template variables to SQL queries</li>\n<li>Fix async queries and expressions https://github.com/grafana/redshift-datasource/pull/225</li>\n</ul>\n<h2>1.8.4</h2>\n<ul>\n<li>Upgrade Readme.md re: Grafana 10 https://github.com/grafana/redshift-datasource/pull/224</li>\n</ul>\n<h2>1.8.3</h2>\n<ul>\n<li>Upgrade grafana/aws-sdk-react to 0.0.46 https://github.com/grafana/redshift-datasource/pull/223</li>\n</ul>\n<h2>1.8.2</h2>\n<ul>\n<li>Update grafana-aws-sdk version to include new region in opt-in region list https://github.com/grafana/grafana-aws-sdk/pull/80</li>\n<li>Security: Upgrade Go in build process to 1.20.4</li>\n<li>Update grafana-plugin-sdk-go version to 0.161.0 to avoid a potential http header problem. https://github.com/grafana/athena-datasource/issues/233</li>\n</ul>\n<h2>1.8.1</h2>\n<ul>\n<li>Update async-query-data with a fix for errors in <a href="https://github.com/grafana/redshift-datasource/pull/220" target="_blank">#220</a></li>\n</ul>\n<h2>1.8.0</h2>\n<ul>\n<li>Update backend dependencies</li>\n</ul>\n<h2>1.7.0</h2>\n<ul>\n<li>Fix converting rows with FLOAT, FLOAT4, and BOOLEAN by @iwysiu in <a href="https://github.com/grafana/redshift-datasource/pull/213" target="_blank">#213</a></li>\n<li>Add header component to Query Editor by @idastambuk in <a href="https://github.com/grafana/redshift-datasource/pull/214" target="_blank">#214</a></li>\n<li>Use organization ISSUE_COMMANDS_TOKEN with reduced scope by @iwysiu in <a href="https://github.com/grafana/redshift-datasource/pull/210" target="_blank">#210</a></li>\n</ul>\n<h2>1.6.0</h2>\n<ul>\n<li>Remove run and cancel buttons in annotations editor in https://github.com/grafana/redshift-datasource/pull/206</li>\n</ul>\n<h2>1.5.0</h2>\n<ul>\n<li>Migrate to create-plugin by @iwysiu in https://github.com/grafana/redshift-datasource/pull/195</li>\n<li>Update code coverage in workflow to latest by @idastambuk in https://github.com/grafana/redshift-datasource/pull/198</li>\n<li>Update @grafana/aws-sdk by @kevinwcyu in https://github.com/grafana/redshift-datasource/pull/199</li>\n<li>Update @grafana/ packages by @idastambuk in https://github.com/grafana/redshift-datasource/pull/201</li>\n<li>Upgrade grafana-aws-sdk to v0.12.0 by @fridgepoet in https://github.com/grafana/redshift-datasource/pull/202</li>\n</ul>\n<h2>1.4.1</h2>\n<ul>\n<li>Hide the stop button when async query data support is not enabled https://github.com/grafana/redshift-datasource/pull/196</li>\n</ul>\n<h2>1.4.0</h2>\n<ul>\n<li>Add Async Query Data Support https://github.com/grafana/redshift-datasource/pull/177</li>\n</ul>\n<h2>1.3.3</h2>\n<ul>\n<li>Update @grafana dependencies to v8.5.10 https://github.com/grafana/redshift-datasource/pull/194</li>\n</ul>\n<h2>1.3.2</h2>\n<ul>\n<li>Security: Upgrade Go in build process to 1.19.3</li>\n</ul>\n<h2>1.3.1</h2>\n<ul>\n<li>Security: Upgrade Go in build process to 1.19.2</li>\n</ul>\n<h2>1.3.0</h2>\n<ul>\n<li>Upgrade to grafana-aws-sdk v0.11.0 by @fridgepoet in https://github.com/grafana/redshift-datasource/pull/183</li>\n</ul>\n<h2>1.2.0</h2>\n<ul>\n<li>Add database security monitoring dashboards by @yota-p in https://github.com/grafana/redshift-datasource/pull/175</li>\n</ul>\n<h2>1.1.0</h2>\n<ul>\n<li>Add support for context aware autocompletion by @sunker in https://github.com/grafana/redshift-datasource/pull/174</li>\n</ul>\n<h2>1.0.7</h2>\n<ul>\n<li>Bug fix for auth issues with when using keys and dependency upgrades (https://github.com/grafana/redshift-datasource/pull/165)</li>\n<li>Updates to code coverage</li>\n</ul>\n<h2>1.0.6</h2>\n<h3>What\'s Changed</h3>\n<ul>\n<li>Update grafana-aws-sdk by @andresmgot in https://github.com/grafana/redshift-datasource/pull/146</li>\n<li>Autocomplete: Render SQL editor in case feature toggle is enabled by @sunker in https://github.com/grafana/redshift-datasource/pull/151</li>\n<li>fix: WLM panels query fix by @vgkowski in https://github.com/grafana/redshift-datasource/pull/152</li>\n<li>Custom redshift language by @sunker in https://github.com/grafana/redshift-datasource/pull/154</li>\n<li>Align Monaco language with official language ref by @sunker in https://github.com/grafana/redshift-datasource/pull/156</li>\n</ul>\n<p><strong>Full Changelog</strong>: https://github.com/grafana/redshift-datasource/compare/v1.0.5...v1.0.6</p>\n<h2>1.0.5</h2>\n<ul>\n<li>Reduces backoff time factor to retrieve results.</li>\n<li>Upgrades internal dependencies.</li>\n</ul>\n<h2>1.0.4</h2>\n<ul>\n<li>Add details in the datasource card #130</li>\n<li>Enable WithEvent to send an event to the AWS EventBridge #132</li>\n</ul>\n<h2>1.0.3</h2>\n<p>Fixes bugs for Endpoint and Assume Role settings.</p>\n<h2>1.0.2</h2>\n<p>Fixes a bug preventing from getting null values in a query.</p>\n<h2>1.0.1</h2>\n<p>Fixes a bug preventing from creating several data sources of the plugin in the same instance.</p>\n<h2>1.0.0</h2>\n<p>Initial release.</p>\n<h2>0.4.1</h2>\n<p>Improved curated dashboard.</p>\n<h2>0.4.0</h2>\n<p>Allow to authenticate using AWS Secret Manager. More bug fixes.</p>\n<h2>0.3.0</h2>\n<p>Third preview release. Includes curated dashboard.</p>\n<h2>0.2.0</h2>\n<p>Second release.</p>\n<h2>0.1.0</h2>\n<p>Initial release.</p>\n',
  },
} as CatalogPlugin;
