// UI-specific types for Secrets Keeper
// API types (Keeper, KeeperSpec, etc.) come from the generated client:
// app/extensions/api/clients/secret/v1beta1/endpoints.gen

// Matches the provider config keys on KeeperSpec (apps/secret/pkg/apis/secret/v1beta1).
// 'system' is the default when no provider config is set (Grafana-managed storage).
// 'unknown' is a fallback for provider types added to the backend but not yet handled in the UI.
export type KeeperType = 'aws' | 'system' | 'unknown';

export interface KeeperProvider {
  id: KeeperType;
  name: string;
  description: string;
  logoSrc: string;
  tags: string[];
}

// UI-specific keeper with computed fields for display
export interface KeeperListItem {
  name: string;
  type: KeeperType;
  description: string;
  isActive: boolean;
  createdAt?: string;
  // For display purposes, e.g., "us-east-1" for AWS
  config: string;
}
