import { useMemo } from 'react';

import { extractErrorMessage } from 'app/api/utils';
import { generatedAPI as secretAPIv1beta1 } from 'app/extensions/api/clients/secret/v1beta1';

import { KeeperListItem } from '../types';
import { keeperToListItem } from '../utils';

export interface UseKeepersResult {
  keepers: KeeperListItem[];
  isLoading: boolean;
  error: Error | undefined;
  activeKeeper: KeeperListItem | undefined;
}

export const useKeepers = (): UseKeepersResult => {
  const { data, isLoading, error } = secretAPIv1beta1.useListKeeperQuery({});

  // TODO: Active keeper status is not exposed in the API response.
  // Using first keeper as mock active state for demo purposes.
  // Replace with real API data when backend adds active field to list/get responses.
  const { keepers, activeKeeper } = useMemo(() => {
    if (!data?.items) {
      return { keepers: [], activeKeeper: undefined };
    }

    const sorted = data.items.map(keeperToListItem).sort((a, b) => a.name.localeCompare(b.name));

    // Mock: treat first sorted keeper as active until backend exposes this
    const activeName = sorted.length > 0 ? sorted[0].name : undefined;
    const keepersWithActive = sorted.map((k) => (k.name === activeName ? { ...k, isActive: true } : k));
    const active = keepersWithActive.find((k) => k.isActive);

    return { keepers: keepersWithActive, activeKeeper: active };
  }, [data]);

  return {
    keepers,
    isLoading,
    error: error ? new Error(extractErrorMessage(error)) : undefined,
    activeKeeper,
  };
};
