import { NavModelItem } from '@grafana/data';
import { t } from '@grafana/i18n';
import { Page } from 'app/core/components/Page/Page';

import { KeeperTypeChooser } from './components/KeeperTypeChooser';
import { SECRETS_KEEPER_BASE_URL } from './constants';

export const CreateKeeperPage = (): JSX.Element => {
  const keepersParent: NavModelItem = {
    text: t('secrets.tabs.keepers', 'Keepers'),
    url: SECRETS_KEEPER_BASE_URL,
  };

  const pageNav: NavModelItem = {
    text: t('secrets-keeper.create.title', 'Choose a keeper type'),
    subTitle: t(
      'secrets-keeper.create.subtitle',
      'Pick between different types of keepers to store and manage your secrets. Choose the one that best fits your needs.'
    ),
    parentItem: keepersParent,
  };

  return (
    <Page navId="secrets-management" pageNav={pageNav}>
      <Page.Contents>
        <KeeperTypeChooser />
      </Page.Contents>
    </Page>
  );
};

export default CreateKeeperPage;
