import { Keeper, KeeperSpec } from 'app/extensions/api/clients/secret/v1beta1/endpoints.gen';

import { KeeperListItem, KeeperType } from './types';

// All KeeperSpec keys we explicitly handle (providers + metadata fields).
// If codegen adds a new key and we haven't added a branch for it,
// hasUnhandledSpecKey will catch it and map to 'unknown'.
const HANDLED_SPEC_KEYS: ReadonlySet<string> = new Set<keyof KeeperSpec>(['description', 'aws']);

function hasUnhandledSpecKey(spec: KeeperSpec): boolean {
  return Object.keys(spec).some((key) => !HANDLED_SPEC_KEYS.has(key) && spec[key as keyof KeeperSpec] != null);
}

export const keeperToListItem = (keeper: Keeper): KeeperListItem => {
  let type: KeeperType = 'system';
  let config = '';

  if (keeper.spec.aws) {
    type = 'aws';
    config = keeper.spec.aws.region;
  } else if (hasUnhandledSpecKey(keeper.spec)) {
    type = 'unknown';
  }

  return {
    name: keeper.metadata.name ?? '',
    type,
    description: keeper.spec.description,
    isActive: false,
    createdAt: keeper.metadata.creationTimestamp,
    config,
  };
};
