import { t } from '@grafana/i18n';

import awsSecretsManagerLogo from './assets/aws-secrets-manager.svg';
import { KeeperProvider } from './types';

export const SECRETS_KEEPER_BASE_URL = '/admin/secrets/keepers';
export const SECRETS_KEEPER_NEW_URL = `${SECRETS_KEEPER_BASE_URL}/new`;

export const getKeeperProviders = (): KeeperProvider[] => [
  {
    id: 'aws',
    name: t('secrets-keeper.provider.aws.name', 'AWS Secrets Manager'),
    description: t(
      'secrets-keeper.provider.aws.description',
      'Store and manage secrets using Amazon Web Services Secrets Manager with IAM role-based authentication.'
    ),
    logoSrc: awsSecretsManagerLogo,
    tags: ['AWS', 'Cloud', 'IAM'],
  },
];
