import { defineConfig } from 'i18next-cli';

export default defineConfig({
  locales: ['en-US'], // Only en-US  is updated - Crowdin will PR with other languages
  extract: {
    input: ['**/*.{tsx,ts}'],
    output: 'locales/{{language}}/{{namespace}}.json',
    defaultNS: 'mssql',
    functions: ['t', '*.t'],
    transComponents: ['Trans'],
    sort: (a, b) => (a.key > b.key ? 1 : a.key < b.key ? -1 : 0),
  },
});
