// Copyright 2021 Grafana Labs
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package grafanaplugin

import (
	"github.com/grafana/grafana/packages/grafana-schema/src/common"
)

composableKinds: PanelCfg: {
	maturity: "experimental"

	lineage: {
		schemas: [{
			version: [0, 0]
			schema: {
				GaugePanelEffects: {
					barGlow?: bool | *false
					centerGlow?: bool | *false
					gradient?: bool | *true
				} @cuetsy(kind="interface")

				Options: {
					common.SingleStatBaseOptions
					showThresholdLabels:  bool | *false
					showThresholdMarkers: bool | *true
					sizing:               common.BarGaugeSizing & (*"auto" | _)
					minVizWidth:          uint32 | *75
					minVizHeight:         uint32 | *75
					segmentCount:         number | *1
					segmentSpacing:       number | *0.3
					sparkline?:           bool | *true
					shape:                "circle" | *"gauge"
					barWidthFactor:       number | *0.5
					barShape:             "flat" | "rounded" | *"flat"
					endpointMarker?:      "point" | "glow" | "none" | *"point"
					textMode?:            "auto" | "value_and_name" | "value" | "name" | "none" | *"auto"
					neutral?:             number
					effects:              GaugePanelEffects | *{}
				} @cuetsy(kind="interface")
			}
		}]
		lenses: []
	}
}
