---
canonical: https://grafana.com/docs/grafana/latest/alerting/configure-notifications/manage-contact-points/integrations/configure-slack/
description: Configure the Slack integration to connect alerts generated by Grafana Alerting
keywords:
  - grafana
  - alerting
  - slack
  - integration
labels:
  products:
    - cloud
    - enterprise
    - oss
menuTitle: Slack
title: Configure Slack for Alerting
weight: 155
refs:
  notification-templates:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/alerting/configure-notifications/template-notifications/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/alerting/configure-notifications/template-notifications/
  nested-policy:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/alerting/configure-notifications/create-notification-policy/#add-new-nested-policy
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/alerting/configure-notifications/create-notification-policy/#add-new-nested-policy
---

# Configure Slack for Alerting

Use the Grafana Alerting - Slack integration to send Slack notifications when your alerts are firing.

There are two ways of integrating Slack into Grafana Alerting.

1. Use a [Slack API token](https://api.slack.com/authentication/token-types)

   Enable your app to access the Slack API. If, for example, you are interested in more granular control over permissions, or your project is expected to regularly scale, resulting in new channels being created, this is the best option.

1. Use a [Webhook URL](https://api.slack.com/messaging/webhooks)

   Webhooks is the simpler way to post messages into Slack. Slack automatically creates a bot user with all the necessary permissions to post messages to one particular channel of your choice.

Note that you can only setup one Slack channel per contact point.

You can customize the `title` and `body` of the Slack message using [notification templates](ref:notification-templates); however, you cannot modify its visual appearance with custom blocks. Additional optional settings are available to customize bot appearance, mentions, and message formatting. Refer to the [Optional settings](#optional-settings) section for more details.

## Before you begin

### Slack API Token

If you are using a Slack API Token, complete the following steps.

1. Follow step 1 of the [Slack API Quickstart](https://docs.slack.dev/app-management/quickstart-app-settings/#creating) to create the app.
1. Continue onto the second step of the [Slack API Quickstart](https://docs.slack.dev/app-management/quickstart-app-settings/#scopes) and add the [chat:write.public](https://api.slack.com/scopes/chat:write.public) scope as described to give your app the ability to post in all public channels without joining.
1. In OAuth Tokens for Your Workspace, copy the Bot User OAuth Token.
1. Open your Slack workplace.
1. Right click the channel you want to receive notifications in.
1. Click View channel details.
1. Scroll down and copy the Channel ID.

   Note that while going through these steps, Slack may prompt you to Reinstall your app in order for the changes to take effect.

### Webhook URL

If you are using a Webhook URL, complete the following steps.

1. Follow the [Creating an app](https://docs.slack.dev/app-management/quickstart-app-settings/#creating) section of the Slack API Quickstart to create the app.
1. Follow the [Create an incoming webhook](https://api.slack.com/messaging/webhooks#create_a_webhook) section of the Slack Incoming Webhooks guide to enable incoming webhooks for your app and create a webhook for your workspace.
1. Copy the **Webhook URL** that starts with `https://hooks.slack.com/services/`. You need this when setting up your contact point integration in Grafana Alerting.

## Procedure

To create your Slack integration in Grafana Alerting, complete the following steps.

1. Navigate to **Alerts & IRM** -> **Alerting** -> **Contact points**.
1. Click **+ Add contact point**.
1. Enter a contact point name.
1. From the Integration list, select Slack.
1. If you are using a Slack API token:
   - In the **Recipient** field, copy in the channel ID.
   - In the **Token** field, copy in the Bot User OAuth Token that starts with “xoxb-”.
1. If you are using a Webhook URL, in the **Webhook** field, copy in your Slack app Webhook URL.
1. Click **Test** to check that your integration works.

   ** For Grafana Alertmanager only.**

1. Click **Save contact point**.

## Optional settings

You can configure additional settings to customize your Slack notifications beyond the required fields.

### Customize bot appearance

You can customize how the bot appears in Slack channels:

| Option     | Description                                                                                                                             |
| ---------- | --------------------------------------------------------------------------------------------------------------------------------------- |
| Username   | Override the default bot username that appears in Slack. Set the `username` field to customize the display name.                        |
| Icon emoji | Provide an emoji to use as the icon for the message. Set the `icon_emoji` field (for example, `:rocket:`). This overrides the icon URL. |
| Icon URL   | Provide a URL to an image to use as the icon for the message. Set the `icon_url` field with the image URL.                              |

### Configure mentions

You can automatically mention users, groups, or the entire channel when notifications are sent:

| Option          | Description                                                                                                                                                                                                                                                                               |
| --------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Mention users   | Mention one or more specific users in the notification. Set the `mentionUsers` field with a comma-separated list of user IDs (for example, `U024BE7LH,U024BE7LJ`). To find a user's ID, refer to [Slack's documentation on finding member IDs](https://api.slack.com/methods/users.list). |
| Mention groups  | Mention one or more user groups in the notification. Set the `mentionGroups` field with a comma-separated list of group IDs. You can copy group IDs from the group's Slack profile URL.                                                                                                   |
| Mention channel | Mention the entire channel or active members. Set the `mentionChannel` field to one of the following:<br>- Empty or omit the field to disable channel mentions<br>- `here` to mention every active channel member<br>- `channel` to mention every channel member                          |

### Customize message content

You can customize the notification message using [notification templates](ref:notification-templates):

| Option    | Description                                                                                                                                        |
| --------- | -------------------------------------------------------------------------------------------------------------------------------------------------- |
| Title     | Set a custom title for the Slack message. Use the `title` field with template variables (for example, `{{ template "slack.default.title" . }}`).   |
| Text body | Set a custom body text for the Slack message. Use the `text` field with template variables (for example, `{{ template "slack.default.text" . }}`). |
| Color     | Set the color of the vertical bar on the left side of the message attachment. Use the `color` field.                                               |

### Advanced configuration

For specialized environments, you can override the default Slack API endpoint:

| Option       | Description                                                                                                                                                                 |
| ------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Endpoint URL | Specify a custom Slack API endpoint for non-webhook requests. Set the `endpointUrl` field to your custom endpoint. The default is `https://slack.com/api/chat.postMessage`. |

## Next steps

The Slack contact point is ready to receive alert notifications.

To add this contact point to your alert, complete the following steps.

1. In Grafana, navigate to **Alerting** > **Alert rules**.
1. Edit or create a new alert rule.
1. Scroll down to the **Configure labels and notifications** section.
1. Under Notifications click **Select contact point**.
1. From the drop-down menu, select the previously created contact point.
1. **Click Save rule and exit**.
