import { metricAggregationConfig, pipelineOptions } from './components/QueryEditor/MetricAggregationsEditor/utils';
import {
  DateHistogram,
  ElasticsearchDataQuery,
  ExtendedStat,
  MetricAggregation,
  MetricAggregationType,
  MovingAverageModelOption,
} from './dataquery.gen';
import type { QueryType } from './types';

export const extendedStats: ExtendedStat[] = [
  { label: 'Avg', value: 'avg' },
  { label: 'Min', value: 'min' },
  { label: 'Max', value: 'max' },
  { label: 'Sum', value: 'sum' },
  { label: 'Count', value: 'count' },
  { label: 'Std Dev', value: 'std_deviation' },
  { label: 'Std Dev Upper', value: 'std_deviation_bounds_upper' },
  { label: 'Std Dev Lower', value: 'std_deviation_bounds_lower' },
];

export const movingAvgModelOptions: MovingAverageModelOption[] = [
  { label: 'Simple', value: 'simple' },
  { label: 'Linear', value: 'linear' },
  { label: 'Exponentially Weighted', value: 'ewma' },
  { label: 'Holt Linear', value: 'holt' },
  { label: 'Holt Winters', value: 'holt_winters' },
];

export const highlightTags = {
  pre: '@HIGHLIGHT@',
  post: '@/HIGHLIGHT@',
};

export const defaultGeoHashPrecisionString = '3';

export function defaultMetricAgg(id = '1'): MetricAggregation {
  return { type: 'count', id };
}

export function defaultBucketAgg(id = '1'): DateHistogram {
  return { type: 'date_histogram', id, settings: { interval: 'auto' } };
}

export function queryTypeToMetricType(type?: QueryType): MetricAggregation['type'] {
  if (!type) {
    return 'count'; // Default fallback
  }

  switch (type) {
    case 'logs':
    case 'raw_data':
    case 'raw_document':
      return type;
    case 'metrics':
      return 'count';
    default:
      // should never happen
      throw new Error(`invalid query type: ${type}`);
  }
}

export const findMetricById = (metrics: MetricAggregation[], id: MetricAggregation['id']) =>
  metrics.find((metric) => metric.id === id);

export function hasMetricOfType(target: ElasticsearchDataQuery, type: MetricAggregationType): boolean {
  return !!target?.metrics?.some((m) => m.type === type);
}

// Even if we have type guards when building a query, we currently have no way of getting this information from the response.
// We should try to find a better (type safe) way of doing the following 2.
export function isPipelineAgg(metricType: MetricAggregationType) {
  return metricType in pipelineOptions;
}

export function isPipelineAggWithMultipleBucketPaths(metricType: MetricAggregationType) {
  return !!metricAggregationConfig[metricType].supportsMultipleBucketPaths;
}
