---
aliases:
  - ../../../enterprise/access-control/custom-role-actions-scopes/
  - ../../../enterprise/access-control/permissions/
description: Learn about Grafana RBAC permissions, actions, and scopes.
labels:
  products:
    - cloud
    - enterprise
menuTitle: RBAC permissions, actions, and scopes
title: Grafana RBAC permissions, actions, and scopes
weight: 80
refs:
  rbac-grafana-provisioning:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/administration/roles-and-permissions/access-control/rbac-grafana-provisioning/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/account-management/authentication-and-permissions/access-control/rbac-grafana-provisioning/
  rbac-fixed-roles:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/administration/roles-and-permissions/access-control/#fixed-roles
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/account-management/authentication-and-permissions/access-control/#fixed-roles
---

# RBAC permissions, actions, and scopes

{{< admonition type="note" >}}
Available in [Grafana Enterprise](/docs/grafana/<GRAFANA_VERSION>/introduction/grafana-enterprise/) and [Grafana Cloud](/docs/grafana-cloud/).
{{< /admonition >}}

A permission is comprised of an action and a scope. When creating a custom role, consider the actions the user can perform and the resources on which they can perform those actions.

To learn more about the Grafana resources to which you can apply RBAC, refer to [Resources with RBAC permissions](ref:rbac-fixed-roles).

- **Action:** An action describes what tasks a user can perform on a resource.
- **Scope:** A scope describes where an action can be performed, such as reading a specific user profile. In this example, a permission is associated with the scope `users:<userId>` to the relevant role.

## Action definitions

The following list contains role-based access control actions.

<!-- prettier-ignore-start -->
| Action                                | Applicable scopes                                                                                                   | Description                                                                                                                                                                                                               |
|---------------------------------------| ------------------------------------------------------------------------------------------------------------------- |---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `alert.instances.external:read`       | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Read alerts and silences in data sources that support alerting.                                                                                                                                                           |
| `alert.instances.external:write`      | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Manage alerts and silences in data sources that support alerting.                                                                                                                                                         |
| `alert.instances:create`              | None                                                                                                                | Create silences in the current organization.                                                                                                                                                                              |
| `alert.instances:read`                | None                                                                                                                | Read alerts and silences in the current organization.                                                                                                                                                                     |
| `alert.instances:write`               | None                                                                                                                | Update and expire silences in the current organization.                                                                                                                                                                   |
| `alert.notifications.external:read`   | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Read templates, contact points, notification policies, and mute timings in data sources that support alerting.                                                                                                            |
| `alert.notifications.external:write`  | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Manage templates, contact points, notification policies, and mute timings in data sources that support alerting.                                                                                                          |
| `alert.notifications:write`           | None                                                                                                                | Manage templates, contact points, notification policies, and mute timings in the current organization.                                                                                                                    |
| `alert.notifications:read`            | None                                                                                                                | Read all templates, contact points, notification policies, and mute timings in the current organization.                                                                                                                  |
| `alert.rules.external:read`           | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Read alert rules in data sources that support alerting (Prometheus, Mimir, and Loki)                                                                                                                                      |
| `alert.rules.external:write`          | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Create, update, and delete alert rules in data sources that support alerting (Mimir and Loki).                                                                                                                            |
| `alert.rules:create`                  | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Create Grafana alert rules in a folder and its subfolders. Combine this permission with `folders:read` in a scope that includes the folder and `datasources:query` in the scope of data sources the user can query.       |
| `alert.rules:delete`                  | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Delete Grafana alert rules in a folder and its subfolders. Combine this permission with `folders:read` in a scope that includes the folder.       |
| `alert.rules:read`                    | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Read Grafana alert rules in a folder and its subfolders. Combine this permission with `folders:read` in a scope that includes the folder and `datasources:query` in the scope of data sources the user can query.         |
| `alert.rules:write`                   | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Update Grafana alert rules in a folder and its subfolders. Combine this permission with `folders:read` in a scope that includes the folder. To allow query modifications add `datasources:query` in the scope of data sources the user can query.       |
| `alert.silences:create`               | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Create rule-specific silences in a folder and its subfolders.                                                                                                                                                             |
| `alert.silences:read`                 | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Read all general silences and rule-specific silences in a folder and its subfolders.                                                                                                                                      |
| `alert.silences:write`                | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Update and expire rule-specific silences in a folder and its subfolders.                                                                                                                                                  |
| `alert.provisioning:read`             | None                                                                                                                | Read all Grafana alert rules, notification policies, etc via provisioning API. Permissions to folders and datasource are not required.                                                                                    |
| `alert.provisioning.secrets:read`     | None                                                                                                                | Same as `alert.provisioning:read` plus ability to export resources with decrypted secrets.                                                                                                                                |
| `alert.provisioning:write`            | None                                                                                                                | Update all Grafana alert rules, notification policies, etc via provisioning API. Permissions to folders and datasource are not required.                                                                                  |
| `alert.provisioning.provenance:write` | None                                                                                                                | Set provisioning status for alerting resources. Cannot be used alone. Requires user to have permissions to access resources                                                                                               |
| `annotations:create`                  | <ul><li>`annotations:*`</li><li>`annotations:type:*`</li><li>`dashboards:*`</li><li>`dashboards:uid:*`</li><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                      | Create annotations.                                                                                                                                                                                                       |
| `annotations:delete`                  | <ul><li>`annotations:*`</li><li>`annotations:type:*`</li><li>`dashboards:*`</li><li>`dashboards:uid:*`</li><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                      | Delete annotations.                                                                                                                                                                                                       |
| `annotations:read`                    | <ul><li>`annotations:*`</li><li>`annotations:type:*`</li><li>`dashboards:*`</li><li>`dashboards:uid:*`</li><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                      | Read annotations and annotation tags.                                                                                                                                                                                     |
| `annotations:write`                   | <ul><li>`annotations:*`</li><li>`annotations:type:*`</li><li>`dashboards:*`</li><li>`dashboards:uid:*`</li><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                      | Update annotations.                                                                                                                                                                                                       |
| `banners:write`                       | None                                                                                                                | Create [announcement banners](/docs/grafana-cloud/whats-new/2024-09-10-announcement-banner/).                                                                                                                             |
| `dashboards:create`                   | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Create dashboards in one or more folders and their subfolders.                                                                                                                                                            |
| `dashboards:delete`                   | <ul><li>`dashboards:*`</li><li>`dashboards:uid:*`</li><li>`folders:*`</li><li>`folders:uid:*`</li></ul>             | Delete one or more dashboards.                                                                                                                                                                                            |
| `dashboards.insights:read`            | None                                                                                                                | Read dashboard insights data and see presence indicators. To view insights, `dashboards:read` on the dashboard is also needed.                                                                                            |
| `dashboards.permissions:read`         | <ul><li>`dashboards:*`</li><li>`dashboards:uid:*`</li><li>`folders:*`</li><li>`folders:uid:*`</li></ul>             | Read permissions for one or more dashboards.                                                                                                                                                                              |
| `dashboards.permissions:write`        | <ul><li>`dashboards:*`</li><li>`dashboards:uid:*`</li><li>`folders:*`</li><li>`folders:uid:*`</li></ul>             | Update permissions for one or more dashboards.                                                                                                                                                                            |
| `dashboards:read`                     | <ul><li>`dashboards:*`</li><li>`dashboards:uid:*`</li><li>`folders:*`</li><li>`folders:uid:*`</li></ul>             | Read one or more dashboards.                                                                                                                                                                                              |
| `dashboards:write`                    | <ul><li>`dashboards:*`</li><li>`dashboards:uid:*`</li><li>`folders:*`</li><li>`folders:uid:*`</li></ul>             | Update one or more dashboards.                                                                                                                                                                                            |
| `dashboards.public:write`             | <ul><li>`dashboards:*`</li><li>`dashboards:uid:*`</li></ul>                                                         | Write shared dashboard configuration.                                                                                                                                                                                     |
| `datasources.caching:read`            | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Read data source query caching settings.                                                                                                                                                                                  |
| `datasources.caching:write`           | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Update data source query caching settings.                                                                                                                                                                                |
| `datasources:create`                  | None                                                                                                                | Create data sources.                                                                                                                                                                                                      |
| `datasources:delete`                  | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Delete data sources.                                                                                                                                                                                                      |
| `datasources:explore`                 | None                                                                                                                | Enable access to the **Explore** tab.                                                                                                                                                                                     |
| `datasources.id:read`                 | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Read data source IDs.                                                                                                                                                                                                     |
| `datasources.insights:read`           | None                                                                                                                | Read data sources insights data. To view insights, `datasources:read` on the datasource is also needed.                                                                                                                   |
| `datasources.permissions:read`        | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | List data source permissions.                                                                                                                                                                                             |
| `datasources.permissions:write`       | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Update data source permissions.                                                                                                                                                                                           |
| `datasources:query`                   | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Query data sources.                                                                                                                                                                                                       |
| `datasources:read`                    | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | List data sources.                                                                                                                                                                                                        |
| `datasources:write`                   | <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>                                                       | Update data sources.                                                                                                                                                                                                      |
| `featuremgmt.read`                    | None                                                                                                                | Read feature toggles.                                                                                                                                                                                                     |
| `featuremgmt.write`                   | None                                                                                                                | Write feature toggles.                                                                                                                                                                                                    |
| `folders.permissions:read`            | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Read permissions for one or more folders and their subfolders.                                                                                                                                                            |
| `folders.permissions:write`           | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Update permissions for one or more folders and their subfolders.                                                                                                                                                          |
| `folders:create`                      | <ul><li>`folders:*`</li><li>`folders:uid:*`</li><li>`folders:uid:general`</li></ul>                                 | Create folders or subfolders. If granted with scope `folders:uid:general`, it allows to create root level folders. Otherwise, it allows creating subfolders under the specified folders.                                  |
| `folders:delete`                      | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Delete one or more folders and their subfolders.                                                                                                                                                                          |
| `folders:read`                        | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Read one or more folders and their subfolders.                                                                                                                                                                            |
| `folders:write`                       | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Update one or more folders and their subfolders.                                                                                                                                                                          |
| `ldap.config:reload`                  | None                                                                                                                | Reload the LDAP configuration.                                                                                                                                                                                            |
| `ldap.status:read`                    | None                                                                                                                | Verify the availability of the LDAP server or servers.                                                                                                                                                                    |
| `ldap.user:read`                      | None                                                                                                                | Read users via LDAP.                                                                                                                                                                                                      |
| `ldap.user:sync`                      | None                                                                                                                | Sync users via LDAP.                                                                                                                                                                                                      |
| `library.panels:create`               | <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                                                               | Create a library panel in one or more folders and their subfolders.                                                                                                                                                       |
| `library.panels:read`                 | <ul><li>`folders:*`</li><li>`folders:uid:*`</li><li>`library.panels:*`</li><li>`library.panels:uid:*`</li></ul>     | Read one or more library panels.                                                                                                                                                                                          |
| `library.panels:write`                | <ul><li>`folders:*`</li><li>`folders:uid:*`</li><li>`library.panels:*`</li><li>`library.panels:uid:*`</li></ul>     | Update one or more library panels.                                                                                                                                                                                        |
| `library.panels:delete`               | <ul><li>`folders:*`</li><li>`folders:uid:*`</li><li>`library.panels:*`</li><li>`library.panels:uid:*`</li></ul>     | Delete one or more library panels.                                                                                                                                                                                        |
| `licensing.reports:read`              | None                                                                                                                | Get custom permission reports.                                                                                                                                                                                            |
| `licensing:delete`                    | None                                                                                                                | Delete the license token.                                                                                                                                                                                                 |
| `licensing:read`                      | None                                                                                                                | Read licensing information.                                                                                                                                                                                               |
| `licensing:write`                     | None                                                                                                                | Update the license token.                                                                                                                                                                                                 |
| `migrationassistant:migrate`          | None                                                                                                                | Execute on-prem to cloud migrations through the Migration Assistant.   |
| `org.users:write`                     | <ul><li>`users:*`</li><li>`users:id:*`</li></ul>                                                                    | Update the organization role (`None`, `Viewer`, `Editor`, or `Admin`) of a user.                                                                                                                                          |
| `org.users:add`                       | <ul><li>`users:*`</li><li>`users:id:*`</li></ul>                                                                    | Add a user to an organization or invite a new user to an organization.                                                                                                                                                    |
| `org.users:read`                      | <ul><li>`users:*`</li><li>`users:id:*`</li></ul>                                                                    | Get user profiles within an organization.                                                                                                                                                                                 |
| `org.users:remove`                    | <ul><li>`users:*`</li><li>`users:id:*`</li></ul>                                                                    | Remove a user from an organization.                                                                                                                                                                                       |
| `orgs.preferences:read`               | None                                                                                                                | Read organization preferences.                                                                                                                                                                                            |
| `orgs.preferences:write`              | None                                                                                                                | Update organization preferences.                                                                                                                                                                                          |
| `orgs.quotas:read`                    | None                                                                                                                | Read organization quotas.                                                                                                                                                                                                 |
| `orgs.quotas:write`                   | None                                                                                                                | Update organization quotas.                                                                                                                                                                                               |
| `orgs:create`                         | None                                                                                                                | Create an organization.                                                                                                                                                                                                   |
| `orgs:delete`                         | None                                                                                                                | Delete one or more organizations.                                                                                                                                                                                         |
| `orgs:read`                           | None                                                                                                                | Read one or more organizations.                                                                                                                                                                                           |
| `orgs:write`                          | None                                                                                                                | Update one or more organizations.                                                                                                                                                                                         |
| `plugins.app:access`                  | <ul><li>`plugins:*`</li><li>`plugins:id:*`</li></ul>                                                                | Access one or more application plugins (still enforcing the organization role)                                                                                                                                            |
| `plugins:install`                     | None                                                                                                                | Install and uninstall plugins.                                                                                                                                                                                            |
| `plugins:write`                       | <ul><li>`plugins:*`</li><li>`plugins:id:*`</li></ul>                                                                | Edit settings for one or more plugins.                                                                                                                                                                                    |
| `provisioning:reload`                 | `provisioners:*`                                                                                                    | Reload provisioning files. To find the exact scope for specific provisioner, refer to [Scope definitions](#scope-definitions).                                                                                            |
| `reports:create`                      | None                                                                                                                | Create reports.                                                                                                                                                                                                           |
| `reports:write`                       | <ul><li>`reports:*`</li><li>`reports:id:*`</li></ul>                                                                | Update reports.                                                                                                                                                                                                           |
| `reports.settings:read`               | None                                                                                                                | Read report settings.                                                                                                                                                                                                     |
| `reports.settings:write`              | None                                                                                                                | Update report settings.                                                                                                                                                                                                   |
| `reports:delete`                      | <ul><li>`reports:*`</li><li>`reports:id:*`</li></ul>                                                                | Delete reports.                                                                                                                                                                                                           |
| `reports:read`                        | <ul><li>`reports:*`</li><li>`reports:id:*`</li></ul>                                                                | List all available reports or get a specific report.                                                                                                                                                                      |
| `reports:send`                        | <ul><li>`reports:*`</li><li>`reports:id:*`</li></ul>                                                                | Send a report email.                                                                                                                                                                                                      |
| `roles:delete`                        | <ul><li>`permissions:type:delegate`</li><ul>                                                                        | Delete a custom role.                                                                                                                                                                                                     |
| `roles:read`                          | <ul><li>`roles:*`</li><li>`roles:uid:*`</li></ul>                                                                   | List roles and read a specific role with its permissions.                                                                                                                                                                 |
| `roles:write`                         | <ul><li>`permissions:type:delegate`</li><ul>                                                                        | Create or update a custom role.                                                                                                                                                                                           |
| `roles:write`                         | <ul><li>`permissions:type:escalate`</li><ul>                                                                        | Reset basic roles to their default permissions.                                                                                                                                                                           |
| `secret.securevalues:create`          | <ul><li>`secret.securevalues:*`</li><li>                                                                            | Create secure values.                                                                                                                                                                                                     |
| `secret.securevalues:read`            | <ul><li>`secret.securevalues:*`</li><li>                                                                            | Read and list secure values.                                                                                                                                                                                              |
| `secret.securevalues:write`           | <ul><li>`secret.securevalues:*`</li><li>                                                                            | Update secure values.                                                                                                                                                                                                     |
| `secret.securevalues:delete`          | <ul><li>`secret.securevalues:*`</li><li>                                                                            | Delete secure values.                                                                                                                                                                                                     |
| `server.stats:read`                   | None                                                                                                                | Read Grafana instance statistics.                                                                                                                                                                                         |
| `server.usagestats.report:read`       | None                                                                                                                | View usage statistics report.                                                                                                                                                                                             |
| `serviceaccounts:write`               | <ul><li>`serviceaccounts:*`</li><ul>                                                                                | Create Grafana service accounts.                                                                                                                                                                                          |
| `serviceaccounts:create`              | None                                                                                                                | Update Grafana service accounts.                                                                                                                                                                                          |
| `serviceaccounts:delete`              | <ul><li>`serviceaccounts:*`</li><li>`serviceaccounts:id:*`</li></ul>                                                | Delete Grafana service accounts.                                                                                                                                                                                          |
| `serviceaccounts:read`                | <ul><li>`serviceaccounts:*`</li><li>`serviceaccounts:id:*`</li></ul>                                                | Read Grafana service accounts.                                                                                                                                                                                            |
| `serviceaccounts.permissions:write`   | <ul><li>`serviceaccounts:*`</li><li>`serviceaccounts:id:*`</li></ul>                                                | Update Grafana service account permissions to control who can do what with the service account.                                                                                                                           |
| `serviceaccounts.permissions:read`    | <ul><li>`serviceaccounts:*`</li><li>`serviceaccounts:id:*`</li></ul>                                                | Read Grafana service account permissions to see who can do what with the service account.                                                                                                                                 |
| `settings:read`                       | <ul><li>`settings:*`</li><li>`settings:auth.saml:*`</li><li>`settings:auth.saml:enabled`</li></ul> (property level) | Read the [Grafana configuration settings](/docs/grafana/<GRAFANA_VERSION>/setup-grafana/configure-grafana/)                                                                                                               |
| `settings:write`                      | <ul><li>`settings:*`</li><li>`settings:auth.saml:*`</li><li>`settings:auth.saml:enabled`</li></ul> (property level) | Update any Grafana configuration settings that can be [updated at runtime](/docs/grafana/<GRAFANA_VERSION>/setup-grafana/configure-grafana/settings-updates-at-runtime/).                                                 |
| `support.bundles:create`              | None                                                                                                                | Create support bundles.                                                                                                                                                                                                   |
| `support.bundles:delete`              | None                                                                                                                | Delete support bundles.                                                                                                                                                                                                   |
| `support.bundles:read`                | None                                                                                                                | List and download support bundles.                                                                                                                                                                                        |
| `snapshots:create`                    | None                                                                                                                | Create snapshots.                                                                                                                                                                                                         |
| `snapshots:delete`                    | None                                                                                                                | Delete snapshots.                                                                                                                                                                                                         |
| `snapshots:read`                      | None                                                                                                                | List snapshots.                                                                                                                                                                                                           |
| `status:accesscontrol`                | <ul><li>`services:accesscontrol`</li><ul>                                                                           | Get access-control enabled status.                                                                                                                                                                                        |
| `teams.permissions:read`              | <ul><li>`teams:*`</li><li>`teams:id:*`</li></ul>                                                                    | Read members and Team Sync setup for teams.                                                                                                                                                                               |
| `teams.permissions:write`             | <ul><li>`teams:*`</li><li>`teams:id:*`</li></ul>                                                                    | Add, remove and update members and manage Team Sync setup for teams.                                                                                                                                                      |
| `teams.roles:add`                     | <ul><li>`permissions:type:delegate`</li><ul>                                                                        | Assign a role to a team.                                                                                                                                                                                                  |
| `teams.roles:read`                    | <ul><li>`teams:*`</li><li>`teams:id:*`</li></ul>                                                                    | List roles assigned directly to a team.                                                                                                                                                                                   |
| `teams.roles:remove`                  | <ul><li>`permissions:type:delegate`</li><ul>                                                                        | Unassign a role from a team.                                                                                                                                                                                              |
| `teams:create`                        | None                                                                                                                | Create teams.                                                                                                                                                                                                             |
| `teams:delete`                        | <ul><li>`teams:*`</li><li>`teams:id:*`</li></ul>                                                                    | Delete one or more teams.                                                                                                                                                                                                 |
| `teams:read`                          | <ul><li>`teams:*`</li><li>`teams:id:*`</li></ul>                                                                    | Read one or more teams and team preferences. To list teams through the UI one of the following permissions is required in addition to `teams:read`: `teams:write`, `teams.permissions:read` or `teams.permissions:write`. |
| `teams:write`                         | <ul><li>`teams:*`</li><li>`teams:id:*`</li></ul>                                                                    | Update one or more teams and team preferences.                                                                                                                                                                            |
| `users.authtoken:read`                | <ul><li>`global.users:*`</li><li>`global.users:id:*`</li></ul>                                                      | List authentication tokens that are assigned to a user.                                                                                                                                                                   |
| `users.authtoken:write`               | <ul><li>`global.users:*`</li><li>`global.users:id:*`</li></ul>                                                      | Update authentication tokens that are assigned to a user.                                                                                                                                                                 |
| `users.password:write`                | <ul><li>`global.users:*`</li><li>`global.users:id:*`</li></ul>                                                      | Update a user’s password.                                                                                                                                                                                                 |
| `users.permissions:read`              | <ul><li>`users:*`</li><ul>                                                                                          | List permissions of a user.                                                                                                                                                                                               |
| `users.permissions:write`             | <ul><li>`global.users:*`</li><li>`global.users:id:*`</li></ul>                                                      | Update a user’s organization-level permissions.                                                                                                                                                                           |
| `users.quotas:read`                   | <ul><li>`global.users:*`</li><li>`global.users:id:*`</li></ul>                                                      | List a user’s quotas.                                                                                                                                                                                                     |
| `users.quotas:write`                  | <ul><li>`global.users:*`</li><li>`global.users:id:*`</li></ul>                                                      | Update a user’s quotas.                                                                                                                                                                                                   |
| `users.roles:add`                     | <ul><li>`permissions:type:delegate`</li><ul>                                                                        | Assign a role to a user or a service account.                                                                                                                                                                             |
| `users.roles:read`                    | <ul><li>`users:*`</li><ul>                                                                                          | List roles assigned directly to a user or a service account.                                                                                                                                                              |
| `users.roles:remove`                  | <ul><li>`permissions:type:delegate`</li><ul>                                                                        | Unassign a role from a user or a service account.                                                                                                                                                                         |
| `users:create`                        | None                                                                                                                | Create a user.                                                                                                                                                                                                            |
| `users:delete`                        | <ul><li>`global.users:*`</li><li>`global.users:id:*`</li></ul>                                                      | Delete a user.                                                                                                                                                                                                            |
| `users:disable`                       | <ul><li>`global.users:*`</li><li>`global.users:id:*`</li></ul>                                                      | Disable a user.                                                                                                                                                                                                           |
| `users:enable`                        | <ul><li>`global.users:*`</li><li>`global.users:id:*`</li></ul>                                                      | Enable a user.                                                                                                                                                                                                            |
| `users:logout`                        | <ul><li>`global.users:*`</li><li>`global.users:id:*`</li></ul>                                                      | Sign out a user.                                                                                                                                                                                                          |
| `users:read`                          | <ul><li>`global.users:*`</li><ul>                                                                                   | Read or search user profiles.                                                                                                                                                                                             |
| `users:write`                         | <ul><li>`global.users:*`</li><li>`global.users:id:*`</li></ul>                                                      | Update a user’s profile.                                                                                                                                                                                                  |
{ .no-spacing-list }
<!-- prettier-ignore-end -->

### Grafana Adaptive Metrics action definitions

The following list contains role-based access control actions used by Grafana Adaptive Metrics.

| Action                                               | Applicable scopes | Description                                           |
| ---------------------------------------------------- | ----------------- | ----------------------------------------------------- |
| `grafana-adaptive-metrics-app.plugin:access`         | None              | Access the Adaptive Metrics plugin in Grafana Cloud.  |
| `grafana-adaptive-metrics-app.config:read`           | None              | Read the Adaptive Metrics app configuration.          |
| `grafana-adaptive-metrics-app.config:write`          | None              | Update the Adaptive Metrics app configuration.        |
| `grafana-adaptive-metrics-app.recommendations:read`  | None              | Read aggregation recommendations.                     |
| `grafana-adaptive-metrics-app.recommendations:apply` | None              | Apply aggregation recommendations.                    |
| `grafana-adaptive-metrics-app.rules:read`            | None              | Read aggregation rules.                               |
| `grafana-adaptive-metrics-app.rules:write`           | None              | Create aggregation rules.                             |
| `grafana-adaptive-metrics-app.rules:delete`          | None              | Delete aggregation rules.                             |
| `grafana-adaptive-metrics-app.exemptions:read`       | None              | Read recommendation exemptions.                       |
| `grafana-adaptive-metrics-app.exemptions:write`      | None              | Create, update, and delete recommendation exemptions. |

### Cloud Access Policies action definitions

The following list contains role-based access control actions used by Cloud Access Policies.

| Action                   | Applicable scopes | Description                                                         |
| ------------------------ | ----------------- | ------------------------------------------------------------------- |
| `grafana-auth-app:write` | None              | Create, read, update, and delete access policies for Grafana Cloud. |

{{< admonition type="warning" >}}
Granting the `grafana-auth-app:write` permission is equivalent to assigning the Admin role to a user in Grafana, as it allows them to manage all stack service accounts. This provides significant privileges and should be assigned with caution.
{{< /admonition >}}

For more information on Cloud Access Policies and how to use them, see [Access policies](https://grafana.com/docs/grafana-cloud/account-management/authentication-and-permissions/access-policies/).

### Grafana Alerting Notification action definitions

| Action                                          | Applicable scopes                  | Description                                                                                                                                                                                                                                          |
| ----------------------------------------------- | ---------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `alert.notifications.receivers:read`            | `receivers:*`<br>`receivers:uid:*` | Read contact points.                                                                                                                                                                                                                                 |
| `alert.notifications.receivers.secrets:read`    | `receivers:*`<br>`receivers:uid:*` | Export contact points with decrypted secrets.                                                                                                                                                                                                        |
| `alert.notifications.receivers:create`          | None                               | Create a new contact points. The creator is automatically granted full access to the created contact point.                                                                                                                                          |
| `alert.notifications.receivers:write`           | `receivers:*`<br>`receivers:uid:*` | Update existing contact points.                                                                                                                                                                                                                      |
| `alert.notifications.receivers.protected:write` | `receivers:*`<br>`receivers:uid:*` | Update [protected fields](/docs/grafana/<GRAFANA_VERSION>/alerting/configure-notifications/manage-contact-points#grafana-cloud-protected-fields) in contact points (such as target URLs for integrations). This scope only applies to Grafana Cloud. |
| `alert.notifications.receivers:delete`          | `receivers:*`<br>`receivers:uid:*` | Update and delete existing contact points.                                                                                                                                                                                                           |
| `alert.notifications.receivers:test`            | None                               | Test contact point notification.                                                                                                                                                                                                                     |
| `receivers.permissions:read`                    | `receivers:*`<br>`receivers:uid:*` | Read permissions for contact points.                                                                                                                                                                                                                 |
| `receivers.permissions:write`                   | `receivers:*`<br>`receivers:uid:*` | Manage permissions for contact points.                                                                                                                                                                                                               |
| `alert.notifications.time-intervals:read`       | None                               | Read mute time intervals.                                                                                                                                                                                                                            |
| `alert.notifications.time-intervals:write`      | None                               | Create new or update existing mute time intervals.                                                                                                                                                                                                   |
| `alert.notifications.time-intervals:delete`     | None                               | Delete existing time intervals.                                                                                                                                                                                                                      |
| `alert.notifications.templates:read`            | None                               | Read templates.                                                                                                                                                                                                                                      |
| `alert.notifications.templates:write`           | None                               | Create new or update existing templates.                                                                                                                                                                                                             |
| `alert.notifications.templates:delete`          | None                               | Delete existing templates.                                                                                                                                                                                                                           |
| `alert.notifications.templates.test:write`      | None                               | Test templates with custom payloads (preview and payload editor functionality).                                                                                                                                                                      |
| `alert.notifications.routes:read`               | None                               | Read notification policies.                                                                                                                                                                                                                          |
| `alert.notifications.routes:write`              | None                               | Create new, update or delete notification policies                                                                                                                                                                                                   |

### Grafana Synthetic Monitoring action definitions

The following list contains role-based access control actions used by Grafana Synthetic Monitoring.

| Action                                                 | Applicable scopes | Description                                                 |
| ------------------------------------------------------ | ----------------- | ----------------------------------------------------------- |
| `grafana-synthetic-monitoring-app:read`                | None              | Read synthetic monitoring app.                              |
| `grafana-synthetic-monitoring-app:write`               | None              | Write synthetic monitoring app.                             |
| `grafana-synthetic-monitoring-app.checks:read`         | None              | Read checks in the Synthetic Monitoring app.                |
| `grafana-synthetic-monitoring-app.checks:write`        | None              | Create and edit checks in the Synthetic Monitoring app.     |
| `grafana-synthetic-monitoring-app.checks:delete`       | None              | Delete checks in the Synthetic Monitoring app.              |
| `grafana-synthetic-monitoring-app.probes:read`         | None              | Read probes in the Synthetic Monitoring app.                |
| `grafana-synthetic-monitoring-app.probes:write`        | None              | Create and edit probes in the Synthetic Monitoring app.     |
| `grafana-synthetic-monitoring-app.probes:delete`       | None              | Delete probes in the Synthetic Monitoring app.              |
| `grafana-synthetic-monitoring-app.alerts:read`         | None              | Read alerts in the Synthetic Monitoring app.                |
| `grafana-synthetic-monitoring-app.alerts:write`        | None              | Create and edit alerts in the Synthetic Monitoring app.     |
| `grafana-synthetic-monitoring-app.alerts:delete`       | None              | Delete alerts in the Synthetic Monitoring app.              |
| `grafana-synthetic-monitoring-app.thresholds:read`     | None              | Read thresholds in the Synthetic Monitoring app.            |
| `grafana-synthetic-monitoring-app.thresholds:write`    | None              | Create and edit thresholds in the Synthetic Monitoring app. |
| `grafana-synthetic-monitoring-app.thresholds:delete`   | None              | Delete thresholds in the Synthetic Monitoring app.          |
| `grafana-synthetic-monitoring-app.access-tokens:write` | None              | Create and delete synthetic monitoring access tokens.       |

## Scope definitions

The following list contains role-based access control scopes.

<!-- prettier-ignore-start -->
| Scopes                                                               | Descriptions                                                                                                                                                                                                                                       |
| -------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| <ul><li>`annotations:*`</li><li>`annotations:type:*`</li></ul>       | Restrict an action to a set of annotations. For example, `annotations:*` matches any annotation, `annotations:type:dashboard` matches annotations associated with dashboards and `annotations:type:organization` matches organization annotations. |
| <ul><li>`dashboards:*`</li><li>`dashboards:uid:*`</li></ul>          | Restrict an action to a set of dashboards. For example, `dashboards:*` matches any dashboard, and `dashboards:uid:1` matches the dashboard whose UID is `1`.                                                                                       |
| <ul><li>`datasources:*`</li><li>`datasources:uid:*`</li></ul>        | Restrict an action to a set of data sources. For example, `datasources:*` matches any data source, and `datasources:uid:1` matches the data source whose UID is `1`.                                                                               |
| <ul><li>`folders:*`</li><li>`folders:uid:*`</li></ul>                | Restrict an action to a set of folders. For example, `folders:*` matches any folder, and `folders:uid:1` matches the folder whose UID is `1`. Note that permissions granted to a folder cascade down to subfolders located under it.               |
| <ul><li>`global.users:*`</li><li>`global.users:id:*`</li></ul>       | Restrict an action to a set of global users. For example, `global.users:*` matches any user and `global.users:id:1` matches the user whose ID is `1`.                                                                                              |
| <ul><li>`library.panels:*`</li><li>`library.panels:uid:*`</li></ul>  | Restrict an action to a set of library panels. For example, `library.panels:*` matches any library panel, and `library.panel:uid:1` matches the library panel whose UID is `1`.                                                                    |
| <ul><li>`orgs:*`</li><li>`orgs:id:*`</li></ul>                       | Restrict an action to a set of organizations. For example, `orgs:*` matches any organization and `orgs:id:1` matches the organization whose ID is `1`.                                                                                             |
| <ul><li>`permissions:type:delegate`</li><ul>                         | The scope is only applicable for roles associated with the Access Control itself and indicates that you can delegate your permissions only, or a subset of it, by creating a new role or making an assignment.                                     |
| <ul><li>`permissions:type:escalate`</li><ul>                         | The scope is required to trigger the reset of basic roles permissions. It indicates that users might acquire additional permissions they did not previously have.                                                                                  |
| <ul><li>`plugins:*`</li><li>`plugins:id:*`</li></ul>                 | Restrict an action to a set of plugins. For example, `plugins:id:grafana-oncall-app` matches Grafana OnCall plugin, and `plugins:*` matches all plugins.                                                                                           |
| <ul><li>`provisioners:*`</li><ul>                                    | Restrict an action to a set of provisioners. For example, `provisioners:*` matches any provisioner, and `provisioners:accesscontrol` matches the role-based access control [provisioner](ref:rbac-grafana-provisioning).           |
| <ul><li>`reports:*`</li><li>`reports:id:*`</li></ul>                 | Restrict an action to a set of reports. For example, `reports:*` matches any report and `reports:id:1` matches the report whose ID is `1`.                                                                                                         |
| <ul><li>`roles:*`</li><li>`roles:uid:*`</li></ul>                    | Restrict an action to a set of roles. For example, `roles:*` matches any role and `roles:uid:randomuid` matches only the role whose UID is `randomuid`.                                                                                            |
| <ul><li>`services:accesscontrol`</li><ul>                            | Restrict an action to target only the role-based access control service. You can use this in conjunction with the `status:accesscontrol` actions.                                                                                                  |
| <ul><li>`serviceaccounts:*`</li><li>`serviceaccounts:id:*`</li></ul> | Restrict an action to a set of service account from an organization. For example, `serviceaccounts:*` matches any service account and `serviceaccount:id:1` matches the service account whose ID is `1`.                                           |
| <ul><li>`settings:*`</li><ul>                                        | Restrict an action to a subset of settings. For example, `settings:*` matches all settings, `settings:auth.saml:*` matches all SAML settings, and `settings:auth.saml:enabled` matches the enable property on the SAML settings.                   |
| <ul><li>`teams:*`</li><li>`teams:id:*`</li></ul>                     | Restrict an action to a set of teams from an organization. For example, `teams:*` matches any team and `teams:id:1` matches the team whose ID is `1`.                                                                                              |
| <ul><li>`users:*`</li><li>`users:id:*`</li></ul>                     | Restrict an action to a set of users from an organization. For example, `users:*` matches any user and `users:id:1` matches the user whose ID is `1`.                                                                                              |
| <ul><li>None</li><ul>                                                | If an action has "None" specified for the scope, then the action doesn't require a scope. For example, the `teams:create` action doesn't require a scope and allows users to create teams.                                                         |
{ .no-spacing-list }
<!-- prettier-ignore-end -->
