import { contextSrv } from 'app/core/core';
import { SavedQuery } from 'app/features/explore/QueryLibrary/types';

export const canEditQuery = (query: SavedQuery) => {
  const userIsAuthor = query.user?.uid?.replace('user:', '') === contextSrv.user.uid;
  const userIsAdmin = contextSrv.hasRole('Admin');

  return (userIsAuthor && contextSrv.isEditor) || userIsAdmin;
};

export const canCreateQuery = () => {
  return contextSrv.isEditor;
};
