---
aliases:
  - ../features/explore/ # /docs/grafana/next/features/explore/
  - ../explore/ # /docs/grafana/next/explore/
  - /docs/grafana-cloud/visualizations/explore/
keywords:
  - explore
  - loki
  - logs
labels:
  products:
    - cloud
    - enterprise
    - oss
menuTitle: Explore
title: Explore
weight: 90
hero:
  title: Explore
  level: 1
  width: 110
  height: 110
  description: >-
    Use Explore to query, collect, and analyze data for detailed real-time data analysis.
cards:
  title_class: pt-0 lh-1
  items:
    - title: Get started with Explore
      href: ./get-started-with-explore/
      description: Get started using Explore to create queries and do real-time analysis on your data.
      height: 24
    - title: Query management
      href: ./query-management/
      description: Learn how to manage queries in Explore.
      height: 24
    - title: Query inspector in Explore
      href: ./explore-inspector/
      description: Learn how to use the Query inspector to troubleshoot issues with your queries.
      height: 24
    - title: Logs in Explore
      href: ./logs-integration/
      description: Learn about working with logs and log data in Explore.
      height: 24
    - title: Traces in Explore
      href: ./trace-integration/
      description: Learn about working with traces and tracing data in Explore.
      height: 24
    - title: Correlations editor in Explore
      href: ./correlations-editor-in-explore/
      description: Learn how to create and use Correlations.
      height: 24
---

{{< docs/hero-simple key="hero" >}}

---

## Overview

Explore is your starting point for querying, analyzing, and aggregating data in Grafana. You can quickly begin creating queries to start analyzing data without having to create a dashboard or customize a visualization.

## Explore

{{< card-grid key="cards" type="simple" >}}
