// This component is used to render the enrichment per rule drawer.

import { ComponentType } from 'react';

import { useEnrichments } from '../helpers/useEnrichments';

import { EnrichmentManageDrawer } from './EnrichmentManageDrawer';

export interface EnrichmentPerRuleDrawerProps {
  ruleUid: string;
  onClose: () => void;
}

export const EnrichmentPerRuleDrawer: ComponentType<EnrichmentPerRuleDrawerProps> = ({ ruleUid, onClose }) => {
  const { ruleLevelEnrichments, globalEnrichments } = useEnrichments();

  return (
    <EnrichmentManageDrawer
      onClose={onClose}
      ruleLevelEnrichments={ruleLevelEnrichments}
      globalEnrichments={globalEnrichments}
      ruleUid={ruleUid}
    />
  );
};
