import { SettingsError } from 'app/features/auth-config/types';

export interface SCIMConfigState {
  scimSettings: SCIMSettingsData;
  isLoading: boolean;
  error?: SettingsError;
  configFoundInIniFile: boolean;
  isUpdated: boolean;
}

export interface SCIMUser {
  id: number;
  uid: string;
  name: string;
  email: string;
  login: string;
  lastSeenAtAge?: string;
  isDisabled: boolean;
}

export interface SCIMFormData {
  userSyncEnabled: boolean;
  groupSyncEnabled: boolean;
  rejectNonProvisionedUsers: boolean;
}

export interface DomainInfo {
  domain: string;
  subdomain: string;
}

export interface SCIMSettingsData {
  userSyncEnabled: boolean;
  groupSyncEnabled: boolean;
  rejectNonProvisionedUsers: boolean;
  hasStaticSettings?: boolean; // Whether static settings actually exist in config.ini
  scimApiEndpoint?: string;
  scimServiceAccountToken?: string;
}
