import { PropsWithChildren } from 'react';

import { QueryLibraryContext } from './QueryLibraryContext';

type Props = {
  queryLibraryEnabled?: boolean;
};

export function QueryLibraryContextProviderMock(props: PropsWithChildren<Props>) {
  return (
    <QueryLibraryContext.Provider
      value={{
        openDrawer: jest.fn(),
        closeDrawer: jest.fn(),
        isDrawerOpen: false,
        renderSavedQueryButtons: jest.fn(),
        renderQueryLibraryEditingHeader: jest.fn(),
        queryLibraryEnabled: Boolean(props.queryLibraryEnabled),
        context: 'explore',
        triggerAnalyticsEvent: jest.fn(),
        setNewQuery: jest.fn(),
        onSelectQuery: jest.fn(),
        setCloseGuard: jest.fn(),
      }}
    >
      {props.children}
    </QueryLibraryContext.Provider>
  );
}
