import { useLocalStorage } from 'react-use';

import { CoreApp } from '@grafana/data';
import { t } from '@grafana/i18n';
import { DataQuery } from '@grafana/schema';
import { Badge } from '@grafana/ui';
import { QueryOperationAction } from 'app/core/components/QueryOperationRow/QueryOperationAction';

import { QUERY_LIBRARY_LOCAL_STORAGE_KEYS } from './QueryLibraryDrawer';
import { selectors } from './e2e-selectors/selectors';
import { useQueryLibrarySave } from './hooks/useQueryLibrarySave';

interface Props {
  query: DataQuery;
  app?: CoreApp;
  onSelectQuery?: (query: DataQuery) => void;
  onUpdateSuccess?: () => void;
}

export function SaveQueryButton({ query, app, onSelectQuery }: Props) {
  const { saveNewQuery } = useQueryLibrarySave();

  const [showQueryLibraryBadgeButton, setShowQueryLibraryBadgeButton] = useLocalStorage(
    QUERY_LIBRARY_LOCAL_STORAGE_KEYS.explore.newButton,
    true
  );

  return showQueryLibraryBadgeButton ? (
    <Badge
      data-testid={selectors.components.saveQueryButton.button}
      text={t('query-operation.header.save-to-query-library-new', 'New: Save query')}
      icon="save"
      color="blue"
      onClick={() => {
        saveNewQuery(query, onSelectQuery, { context: app });
        setShowQueryLibraryBadgeButton(false);
      }}
      style={{ cursor: 'pointer' }}
    />
  ) : (
    <QueryOperationAction
      dataTestId={selectors.components.saveQueryButton.button}
      title={t('query-operation.header.save-to-query-library', 'Save query')}
      icon="save"
      onClick={() => {
        saveNewQuery(query, onSelectQuery, { context: app });
      }}
      isHighlighted
    />
  );
}
