---
headless: true
labels:
  products:
    - enterprise
    - oss
title: Upgrade guide introduction
---

We recommend that you upgrade Grafana often to stay current with the latest fixes and enhancements.
Because Grafana upgrades are backward compatible, the upgrade process is straightforward, and dashboards and graphs will not change.

In addition to common tasks you should complete for all versions of Grafana, there might be additional upgrade tasks to complete for a version.

{{< admonition type="note" >}}
There might be breaking changes in some releases. We outline all these changes in the [What's New](https://grafana.com/docs/grafana/<GRAFANA_VERSION>/whatsnew/) document.
{{< /admonition >}}

For versions of Grafana prior to v9.2, we published additional information in the [Release Notes](https://grafana.com/docs/grafana/<GRAFANA_VERSION>/release-notes/).

When available, we list all changes with links to pull requests or issues in the [Changelog](https://github.com/grafana/grafana/blob/main/CHANGELOG.md).

{{< admonition type="note" >}}
When possible, we recommend that you test the Grafana upgrade process in a test or development environment.
{{< /admonition >}}
