import { t } from '@grafana/i18n';
import { ComboboxOption } from '@grafana/ui';
import { EnricherConfig, Matcher, Step } from 'app/extensions/api/clients/alertenrichment/v0alpha1/endpoints.gen';

export interface AlertEnrichmentFormData {
  spec: {
    title: string;
    description?: string;
    steps: Step[];
  };
  labelMatchers?: Matcher[];
  annotationMatchers?: Matcher[];
}

export type EnrichmentType = EnricherConfig['type'];

const DEFAULT_ENRICHMENT_TIMEOUT = '30s';

export function getInitialFormData(): AlertEnrichmentFormData {
  return {
    spec: {
      title: '',
      description: '',
      steps: [
        {
          timeout: DEFAULT_ENRICHMENT_TIMEOUT,
          type: 'enricher',
          enricher: {
            type: 'assign',
            assign: { annotations: [] },
          },
        },
      ],
    },
  };
}

export function getMatcherTypeOptions() {
  return [
    { label: t('alert-enrichment-form.matcher-type.equals', 'Equals (=)'), value: '=' },
    { label: t('alert-enrichment-form.matcher-type.not-equals', 'Not Equals (!=)'), value: '!=' },
    { label: t('alert-enrichment-form.matcher-type.regex-match', 'Regex Match (=~)'), value: '=~' },
    { label: t('alert-enrichment-form.matcher-type.regex-not-match', 'Regex Not Match (!~)'), value: '!~' },
  ];
}

export function getEnricherTypeOptions(): Array<ComboboxOption<EnrichmentType>> {
  return [
    { label: t('alert-enrichment-form.enricher-type.assign', 'Assign'), value: 'assign' },
    { label: t('alert-enrichment-form.enricher-type.external', 'External'), value: 'external' },
    { label: t('alert-enrichment-form.enricher-type.dsquery', 'Data Source Query'), value: 'dsquery' },
    { label: t('alert-enrichment-form.enricher-type.asserts', 'Asserts'), value: 'asserts' },
    { label: t('alert-enrichment-form.enricher-type.sift', 'Sift'), value: 'sift' },
    { label: t('alert-enrichment-form.enricher-type.explain', 'Explain'), value: 'explain' },
  ];
}

export function getDsTypeOptions() {
  return [
    { label: t('alert-enrichment-form.ds-type.logs', 'Logs'), value: 'logs' },
    { label: t('alert-enrichment-form.ds-type.raw', 'Raw'), value: 'raw' },
  ];
}
