import { locationUtil } from '@grafana/data';
import { locationService } from '@grafana/runtime';
import { getExploreUrl } from 'app/core/utils/explore';
import { getTimeSrv } from 'app/features/dashboard/services/TimeSrv';
import { updateQueryLibraryRefAction } from 'app/features/explore/state/explorePane';
import { store } from 'app/store/store';

import { QueryTemplateRow } from '../types';

export const onOpenInExplore = async (
  query: QueryTemplateRow,
  onCloseDrawer?: (isSelectingQuery?: boolean, isEditingQuery?: boolean) => void
) => {
  if (!query.query || !query.datasourceRef) {
    console.error('Missing required query or datasource reference');
    return;
  }

  try {
    const timeRange = getTimeSrv().timeRange();
    const exploreUrl = await getExploreUrl({
      queries: [query.query],
      dsRef: query.datasourceRef,
      timeRange,
      scopedVars: undefined,
    });

    if (exploreUrl) {
      const url = new URL(exploreUrl, window.location.origin);
      const panesParam = url.searchParams.get('panes');
      if (panesParam) {
        const panes = JSON.parse(panesParam);
        const paneId = Object.keys(panes)[0];

        // neavigate to explore
        locationService.push(locationUtil.stripBaseFromUrl(exploreUrl));

        // set queryLibraryRef after navigation
        setTimeout(() => {
          store.dispatch(
            updateQueryLibraryRefAction({
              exploreId: paneId,
              queryLibraryRef: query.uid,
            })
          );
        }, 200);
      }
      // Close the drawer after navigating to explore
      onCloseDrawer?.(false, true);
    }
  } catch (error) {
    console.error('Failed to open in explore:', error);
  }
};
