"use strict";(self.webpackChunk_grafana_ui=self.webpackChunk_grafana_ui||[]).push([[2563],{"./src/components/UsersIndicator/UsersIndicator.story.tsx":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__),__webpack_require__.d(__webpack_exports__,{Basic:function(){return Basic},WithManyUsers:function(){return WithManyUsers},default:function(){return UsersIndicator_story}});var jsx_runtime=__webpack_require__("../../node_modules/react/jsx-runtime.js"),emotion_css_esm=__webpack_require__("../../node_modules/@emotion/css/dist/emotion-css.esm.js"),i18n=__webpack_require__("../grafana-i18n/src/i18n.tsx"),ThemeContext=__webpack_require__("./src/themes/ThemeContext.tsx"),UserIcon=__webpack_require__("./src/components/UsersIndicator/UserIcon.tsx");const UsersIndicator=({users:users,onClick:onClick,limit:limit=4})=>{const styles=(0,ThemeContext.of)(getStyles);if(!users.length)return null;limit=limit>0?limit:4;const limitReached=users.length>limit,extraUsers=users.length-limit,tooManyUsers=extraUsers>99;return(0,jsx_runtime.jsxs)("div",{className:styles.container,"aria-label":(0,i18n.t)("grafana-ui.users-indicator.container-label","Users indicator container"),children:[limitReached&&(0,jsx_runtime.jsx)(UserIcon.n,{onClick:onClick,userView:{user:{name:"Extra users"},lastActiveAt:""},showTooltip:!1,children:tooManyUsers?"...":`+${extraUsers}`}),users.slice(0,limitReached?limit:limit+1).reverse().map((userView=>(0,jsx_runtime.jsx)(UserIcon.n,{userView:userView},userView.user.name)))]})},getStyles=theme=>({container:(0,emotion_css_esm.AH)({display:"flex",justifyContent:"center",flexDirection:"row-reverse",marginLeft:theme.spacing(1),"& > button":{marginLeft:theme.spacing(-1)}}),dots:(0,emotion_css_esm.AH)({marginBottom:"3px"})});try{UsersIndicator.displayName="UsersIndicator",UsersIndicator.__docgenInfo={description:"",displayName:"UsersIndicator",props:{users:{defaultValue:null,description:"An object that contains the user's details and 'lastActiveAt' status",name:"users",required:!0,type:{name:"UserView[]"}},limit:{defaultValue:{value:"4"},description:"A limit of how many user icons to show before collapsing them and showing a number of users instead",name:"limit",required:!1,type:{name:"number"}},onClick:{defaultValue:null,description:"onClick handler for the user number indicator",name:"onClick",required:!1,type:{name:"(() => void)"}}}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/UsersIndicator/UsersIndicator.tsx#UsersIndicator"]={docgenInfo:UsersIndicator.__docgenInfo,name:"UsersIndicator",path:"src/components/UsersIndicator/UsersIndicator.tsx#UsersIndicator"})}catch(__react_docgen_typescript_loader_error){}__webpack_require__("../../node_modules/react/index.js");var lib=__webpack_require__("../../node_modules/@storybook/addon-docs/node_modules/@mdx-js/react/lib/index.js"),dist=__webpack_require__("../../node_modules/@storybook/addon-docs/node_modules/@storybook/blocks/dist/index.mjs");function _createMdxContent(props){const _components={code:"code",h1:"h1",h2:"h2",p:"p",pre:"pre",...(0,lib.R)(),...props.components};return(0,jsx_runtime.jsxs)(jsx_runtime.Fragment,{children:[(0,jsx_runtime.jsx)(dist.W8,{title:"MDX|UsersIndicator",component:UsersIndicator}),"\n",(0,jsx_runtime.jsx)(_components.h1,{id:"usersindicator",children:"UsersIndicator"}),"\n",(0,jsx_runtime.jsx)(_components.p,{children:"A component that displays a set of user icons indicating which users are currently active. If there are too many users to display all the icons, it will collapse the icons into a single icon with a number indicating the number of additional users."}),"\n",(0,jsx_runtime.jsx)(_components.h2,{id:"usage",children:"Usage"}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-tsx",children:"import { UsersIndicator } from '@grafana/ui';\n\nconst users = [\n  {\n    user: {\n      name: 'John Smith',\n      avatarUrl: 'https://example.com/avatar.png',\n    },\n    lastActiveAt: '2023-04-18T15:00:00.000Z',\n  },\n  {\n    user: {\n      name: 'Jane Doe',\n      avatarUrl: 'https://example.com/avatar.png',\n    },\n    lastActiveAt: '2023-04-17T10:00:00.000Z',\n  },\n  {\n    user: {\n      name: 'Bob Johnson',\n      avatarUrl: 'https://example.com/avatar.png',\n    },\n    lastActiveAt: '2023-04-16T08:00:00.000Z',\n  },\n];\n\nconst ExampleComponent = () => {\n  return (\n    <div>\n      <UsersIndicator users={users} limit={2} />\n    </div>\n  );\n};\n"})}),"\n",(0,jsx_runtime.jsx)(dist.ov,{of:UsersIndicator}),"\n",(0,jsx_runtime.jsx)(_components.h2,{id:"userview-type",children:"UserView type"}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-tsx",children:"import { DateTimeInput } from '@grafana/data';\n\nexport interface UserView {\n  user: {\n    /** User's name, containing first + last name */\n    name: string;\n    /** URL to the user's avatar */\n    avatarUrl?: string;\n  };\n  /** Datetime string when the user was last active */\n  lastActiveAt: DateTimeInput;\n}\n"})})]})}const meta={title:"Iconography/UsersIndicator",component:UsersIndicator,argTypes:{limit:{control:{type:"number",min:1}}},parameters:{docs:{page:function MDXContent(props={}){const{wrapper:MDXLayout}={...(0,lib.R)(),...props.components};return MDXLayout?(0,jsx_runtime.jsx)(MDXLayout,{...props,children:(0,jsx_runtime.jsx)(_createMdxContent,{...props})}):_createMdxContent(props)}},knobs:{disabled:!0},controls:{exclude:["className","onClick"]},actions:{disabled:!0}},args:{onClick:void 0}},Basic=args=>(0,jsx_runtime.jsx)(UsersIndicator,{...args,users:[{name:"John Doe",avatarUrl:"https://picsum.photos/id/1/200/200"},{name:"Jane Smith",avatarUrl:""},{name:"Bob Johnson",avatarUrl:"https://picsum.photos/id/3/200/200"}].map((user=>({user:user,lastActiveAt:(new Date).toDateString()})))});Basic.args={limit:4};const WithManyUsers=args=>(0,jsx_runtime.jsx)(UsersIndicator,{...args,users:[{name:"John Doe",avatarUrl:"https://picsum.photos/id/1/200/200"},{name:"Jane Smith",avatarUrl:""},{name:"Bob Johnson",avatarUrl:"https://picsum.photos/id/3/200/200"},{name:"John Smith",avatarUrl:"https://picsum.photos/id/1/200/200"},{name:"Jane Johnson",avatarUrl:""}].map((user=>({user:user,lastActiveAt:(new Date).toDateString()})))});WithManyUsers.args={limit:4};var UsersIndicator_story=meta;Basic.parameters={...Basic.parameters,docs:{...Basic.parameters?.docs,source:{originalSource:"args => {\n  const users = [{\n    name: 'John Doe',\n    avatarUrl: 'https://picsum.photos/id/1/200/200'\n  }, {\n    name: 'Jane Smith',\n    avatarUrl: ''\n  }, {\n    name: 'Bob Johnson',\n    avatarUrl: 'https://picsum.photos/id/3/200/200'\n  }];\n  return <UsersIndicator {...args} users={users.map(user => ({\n    user,\n    lastActiveAt: new Date().toDateString()\n  }))} />;\n}",...Basic.parameters?.docs?.source}}},WithManyUsers.parameters={...WithManyUsers.parameters,docs:{...WithManyUsers.parameters?.docs,source:{originalSource:"args => {\n  const users = [{\n    name: 'John Doe',\n    avatarUrl: 'https://picsum.photos/id/1/200/200'\n  }, {\n    name: 'Jane Smith',\n    avatarUrl: ''\n  }, {\n    name: 'Bob Johnson',\n    avatarUrl: 'https://picsum.photos/id/3/200/200'\n  }, {\n    name: 'John Smith',\n    avatarUrl: 'https://picsum.photos/id/1/200/200'\n  }, {\n    name: 'Jane Johnson',\n    avatarUrl: ''\n  }];\n  return <UsersIndicator {...args} users={users.map(user => ({\n    user,\n    lastActiveAt: new Date().toDateString()\n  }))} />;\n}",...WithManyUsers.parameters?.docs?.source}}}}}]);