import { SelectableValue, TimeRange } from '@grafana/data';
import { PrometheusDatasource } from '../../datasource';
import { QueryBuilderLabelFilter } from '../shared/types';
import { PromVisualQuery } from '../types';
export interface MetricComboboxProps {
    metricLookupDisabled: boolean;
    query: PromVisualQuery;
    onChange: (query: PromVisualQuery) => void;
    onGetMetrics: () => Promise<SelectableValue[]>;
    datasource: PrometheusDatasource;
    labelsFilters: QueryBuilderLabelFilter[];
    onBlur?: () => void;
    variableEditor?: boolean;
    timeRange: TimeRange;
}
export declare function MetricCombobox({ datasource, query, onChange, onGetMetrics, labelsFilters, variableEditor, timeRange, }: Readonly<MetricComboboxProps>): import("react/jsx-runtime").JSX.Element;
export declare const formatPrometheusLabelFiltersToString: (queryString: string, labelsFilters: QueryBuilderLabelFilter[] | undefined) => string;
export declare const formatPrometheusLabelFilters: (labelsFilters: QueryBuilderLabelFilter[]) => string[];
