"use strict";(self.webpackChunk_grafana_ui=self.webpackChunk_grafana_ui||[]).push([[1923],{"./src/components/Alert/Alert.tsx":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.d(__webpack_exports__,{F:function(){return Alert}});var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__("../../node_modules/react/jsx-runtime.js"),_emotion_css__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__("../../node_modules/@emotion/css/dist/emotion-css.esm.js"),react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__("../../node_modules/react/index.js"),_grafana_e2e_selectors__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__("../grafana-e2e-selectors/src/selectors/index.ts"),_grafana_i18n__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__("../grafana-i18n/src/i18n.tsx"),_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__("./src/themes/ThemeContext.tsx"),_Button_Button__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__("./src/components/Button/Button.tsx"),_Icon_Icon__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__("./src/components/Icon/Icon.tsx"),_Layout_Box_Box__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__("./src/components/Layout/Box/Box.tsx"),_Text_Text__WEBPACK_IMPORTED_MODULE_9__=__webpack_require__("./src/components/Text/Text.tsx");const Alert=react__WEBPACK_IMPORTED_MODULE_2__.forwardRef((({title:title,onRemove:onRemove,children:children,buttonContent:buttonContent,elevated:elevated,bottomSpacing:bottomSpacing,topSpacing:topSpacing,className:className,severity:severity="error",...restProps},ref)=>{const theme=(0,_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_5__.$j)(),hasTitle=Boolean(title),styles=getStyles(theme,severity,hasTitle,elevated,bottomSpacing,topSpacing),role=restProps.role||{error:"alert",warning:"alert",info:"status",success:"status"}[severity],ariaLabel=restProps["aria-label"]||title,closeLabel=(0,_grafana_i18n__WEBPACK_IMPORTED_MODULE_4__.t)("grafana-ui.alert.close-button","Close alert");return(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div",{ref:ref,className:(0,_emotion_css__WEBPACK_IMPORTED_MODULE_1__.cx)(styles.wrapper,className),role:role,"aria-label":ariaLabel,...restProps,children:(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Layout_Box_Box__WEBPACK_IMPORTED_MODULE_8__.a,{"data-testid":_grafana_e2e_selectors__WEBPACK_IMPORTED_MODULE_3__.Tp.components.Alert.alertV2(severity),display:"flex",backgroundColor:severity,borderRadius:"default",paddingY:1,paddingX:2,borderStyle:"solid",borderColor:severity,alignItems:"stretch",boxShadow:elevated?"z3":void 0,children:[(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Layout_Box_Box__WEBPACK_IMPORTED_MODULE_8__.a,{paddingTop:1,paddingRight:2,children:(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div",{className:styles.icon,children:(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon_Icon__WEBPACK_IMPORTED_MODULE_7__.I,{size:"xl",name:getIconFromSeverity(severity)})})}),(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Layout_Box_Box__WEBPACK_IMPORTED_MODULE_8__.a,{paddingY:1,grow:1,children:[(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Text_Text__WEBPACK_IMPORTED_MODULE_9__.E,{color:"primary",weight:"medium",children:title}),children&&(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div",{className:styles.content,children:children})]}),onRemove&&!buttonContent&&(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div",{className:styles.close,children:(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button_Button__WEBPACK_IMPORTED_MODULE_6__.$n,{"aria-label":closeLabel,icon:"times",onClick:onRemove,type:"button",fill:"text",variant:"secondary"})}),onRemove&&buttonContent&&(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Layout_Box_Box__WEBPACK_IMPORTED_MODULE_8__.a,{marginLeft:1,display:"flex",alignItems:"center",children:(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button_Button__WEBPACK_IMPORTED_MODULE_6__.$n,{"aria-label":closeLabel,variant:"secondary",onClick:onRemove,type:"button",children:buttonContent})})]})})}));Alert.displayName="Alert";const getIconFromSeverity=severity=>{switch(severity){case"error":return"exclamation-circle";case"warning":return"exclamation-triangle";case"info":return"info-circle";case"success":return"check"}},getStyles=(theme,severity,hasTitle,elevated,bottomSpacing,topSpacing)=>{const color=theme.colors[severity];return{wrapper:(0,_emotion_css__WEBPACK_IMPORTED_MODULE_1__.AH)({flexGrow:1,marginBottom:theme.spacing(bottomSpacing??2),marginTop:theme.spacing(topSpacing??0),position:"relative","&:before":{content:'""',position:"absolute",top:0,left:0,bottom:0,right:0,background:theme.colors.background.primary,zIndex:-1}}),icon:(0,_emotion_css__WEBPACK_IMPORTED_MODULE_1__.AH)({color:color.text,position:"relative",top:"-1px"}),content:(0,_emotion_css__WEBPACK_IMPORTED_MODULE_1__.AH)({color:theme.colors.text.primary,paddingTop:hasTitle?theme.spacing(.5):0,maxHeight:"50vh",overflowY:"auto"}),close:(0,_emotion_css__WEBPACK_IMPORTED_MODULE_1__.AH)({position:"relative",color:theme.colors.text.secondary,background:"none",display:"flex",top:"-6px",right:"-14px"})}};try{Alert.displayName="Alert",Alert.__docgenInfo={description:"",displayName:"Alert",props:{title:{defaultValue:null,description:"",name:"title",required:!0,type:{name:"string"}},onRemove:{defaultValue:null,description:"On click handler for alert button, mostly used for dismissing the alert",name:"onRemove",required:!1,type:{name:"((event: MouseEvent<Element, MouseEvent>) => void)"}},severity:{defaultValue:{value:"error"},description:"",name:"severity",required:!1,type:{name:"enum",value:[{value:'"info"'},{value:'"success"'},{value:'"error"'},{value:'"warning"'}]}},elevated:{defaultValue:null,description:"",name:"elevated",required:!1,type:{name:"boolean"}},buttonContent:{defaultValue:null,description:"",name:"buttonContent",required:!1,type:{name:"ReactNode"}},bottomSpacing:{defaultValue:null,description:"",name:"bottomSpacing",required:!1,type:{name:"number"}},topSpacing:{defaultValue:null,description:"",name:"topSpacing",required:!1,type:{name:"number"}}}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/Alert/Alert.tsx#Alert"]={docgenInfo:Alert.__docgenInfo,name:"Alert",path:"src/components/Alert/Alert.tsx#Alert"})}catch(__react_docgen_typescript_loader_error){}},"./src/components/Layout/Box/Box.tsx":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.d(__webpack_exports__,{a:function(){return Box}});var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__("../../node_modules/react/jsx-runtime.js"),_emotion_css__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__("../../node_modules/@emotion/css/dist/emotion-css.esm.js"),react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__("../../node_modules/react/index.js"),_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__("./src/themes/ThemeContext.tsx"),_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__("./src/components/Layout/utils/responsiveness.tsx"),_utils_styles__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__("./src/components/Layout/utils/styles.ts");const Box=(0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(((props,ref)=>{const{children:children,margin:margin,marginX:marginX,marginY:marginY,marginTop:marginTop,marginBottom:marginBottom,marginLeft:marginLeft,marginRight:marginRight,padding:padding,paddingX:paddingX,paddingY:paddingY,paddingTop:paddingTop,paddingBottom:paddingBottom,paddingLeft:paddingLeft,paddingRight:paddingRight,display:display,backgroundColor:backgroundColor,grow:grow,shrink:shrink,basis:basis,flex:flex,borderColor:borderColor,borderStyle:borderStyle,borderRadius:borderRadius,direction:direction,justifyContent:justifyContent,alignItems:alignItems,boxShadow:boxShadow,element:element,gap:gap,width:width,minWidth:minWidth,maxWidth:maxWidth,height:height,minHeight:minHeight,maxHeight:maxHeight,position:position,...rest}=props,styles=(0,_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_3__.of)(getStyles,margin,marginX,marginY,marginTop,marginBottom,marginLeft,marginRight,padding,paddingX,paddingY,paddingTop,paddingBottom,paddingLeft,paddingRight,display,backgroundColor,grow,shrink,basis,flex,borderColor,borderStyle,borderRadius,direction,justifyContent,alignItems,boxShadow,gap,position),sizeStyles=(0,_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_3__.of)(_utils_styles__WEBPACK_IMPORTED_MODULE_5__.E,width,minWidth,maxWidth,height,minHeight,maxHeight),Element=element??"div";return(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Element,{ref:ref,className:(0,_emotion_css__WEBPACK_IMPORTED_MODULE_1__.cx)(styles.root,sizeStyles),...rest,children:children})}));Box.displayName="Box";const customBorderColor=(color,theme)=>{switch(color){case"error":case"success":case"info":case"warning":return theme.colors[color].borderTransparent;default:return color?theme.colors.border[color]:void 0}},customBackgroundColor=(color,theme)=>{switch(color){case"error":case"success":case"info":case"warning":return theme.colors[color].transparent;default:return color?theme.colors.background[color]:void 0}},getStyles=(theme,margin,marginX,marginY,marginTop,marginBottom,marginLeft,marginRight,padding,paddingX,paddingY,paddingTop,paddingBottom,paddingLeft,paddingRight,display,backgroundColor,grow,shrink,basis,flex,borderColor,borderStyle,borderRadius,direction,justifyContent,alignItems,boxShadow,gap,position)=>({root:(0,_emotion_css__WEBPACK_IMPORTED_MODULE_1__.AH)([(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,margin,(val=>({margin:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,marginX,(val=>({marginLeft:theme.spacing(val),marginRight:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,marginY,(val=>({marginTop:theme.spacing(val),marginBottom:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,marginTop,(val=>({marginTop:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,marginBottom,(val=>({marginBottom:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,marginLeft,(val=>({marginLeft:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,marginRight,(val=>({marginRight:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,padding,(val=>({padding:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,paddingX,(val=>({paddingLeft:theme.spacing(val),paddingRight:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,paddingY,(val=>({paddingTop:theme.spacing(val),paddingBottom:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,paddingTop,(val=>({paddingTop:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,paddingBottom,(val=>({paddingBottom:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,paddingLeft,(val=>({paddingLeft:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,paddingRight,(val=>({paddingRight:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,display,(val=>({display:val}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,backgroundColor,(val=>({backgroundColor:customBackgroundColor(val,theme)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,direction,(val=>({flexDirection:val}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,grow,(val=>({flexGrow:val}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,shrink,(val=>({flexShrink:val}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,basis,(val=>({flexBasis:val}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,flex,(val=>({flex:val}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,borderStyle,(val=>({borderStyle:val}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,borderColor,(val=>({borderColor:customBorderColor(val,theme)}))),(borderStyle||borderColor)&&{borderWidth:"1px"},(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,justifyContent,(val=>({justifyContent:val}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,alignItems,(val=>({alignItems:val}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,borderRadius,(val=>({borderRadius:theme.shape.radius[val]}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,boxShadow,(val=>({boxShadow:theme.shadows[val]}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,gap,(val=>({gap:theme.spacing(val)}))),(0,_utils_responsiveness__WEBPACK_IMPORTED_MODULE_4__.Y)(theme,position,(val=>({position:val})))])});try{Box.displayName="Box",Box.__docgenInfo={description:"",displayName:"Box",props:{margin:{defaultValue:null,description:"Sets the property `margin`",name:"margin",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},marginX:{defaultValue:null,description:"Sets the properties `margin-top` and `margin-bottom`. Higher priority than margin.",name:"marginX",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},marginY:{defaultValue:null,description:"Sets the properties `margin-left` and `margin-right`. Higher priority than margin.",name:"marginY",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},marginTop:{defaultValue:null,description:"Sets the property `margin-top`. Higher priority than margin and marginY.",name:"marginTop",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},marginBottom:{defaultValue:null,description:"Sets the property `margin-bottom`. Higher priority than margin and marginXY",name:"marginBottom",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},marginLeft:{defaultValue:null,description:"Sets the property `margin-left`. Higher priority than margin and marginX.",name:"marginLeft",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},marginRight:{defaultValue:null,description:"Sets the property `margin-right`. Higher priority than margin and marginX.",name:"marginRight",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},padding:{defaultValue:null,description:"Sets the property `padding`",name:"padding",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},paddingX:{defaultValue:null,description:"Sets the properties `padding-top` and `padding-bottom`. Higher priority than padding.",name:"paddingX",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},paddingY:{defaultValue:null,description:"Sets the properties `padding-left` and `padding-right`. Higher priority than padding.",name:"paddingY",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},paddingTop:{defaultValue:null,description:"Sets the property `padding-top`. Higher priority than padding and paddingY.",name:"paddingTop",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},paddingBottom:{defaultValue:null,description:"Sets the property `padding-bottom`. Higher priority than padding and paddingY.",name:"paddingBottom",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},paddingLeft:{defaultValue:null,description:"Sets the property `padding-left`. Higher priority than padding and paddingX.",name:"paddingLeft",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},paddingRight:{defaultValue:null,description:"Sets the property `padding-right`. Higher priority than padding and paddingX.",name:"paddingRight",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},borderStyle:{defaultValue:null,description:"",name:"borderStyle",required:!1,type:{name:"ResponsiveProp<BorderStyle>"}},borderColor:{defaultValue:null,description:"",name:"borderColor",required:!1,type:{name:"ResponsiveProp<BorderColor>"}},borderRadius:{defaultValue:null,description:"",name:"borderRadius",required:!1,type:{name:"ResponsiveProp<keyof Radii>"}},alignItems:{defaultValue:null,description:"",name:"alignItems",required:!1,type:{name:"ResponsiveProp<AlignItems>"}},direction:{defaultValue:null,description:"",name:"direction",required:!1,type:{name:"ResponsiveProp<Direction>"}},justifyContent:{defaultValue:null,description:"",name:"justifyContent",required:!1,type:{name:"ResponsiveProp<JustifyContent>"}},gap:{defaultValue:null,description:"",name:"gap",required:!1,type:{name:"ResponsiveProp<ThemeSpacingTokens>"}},backgroundColor:{defaultValue:null,description:"",name:"backgroundColor",required:!1,type:{name:"ResponsiveProp<BackgroundColor>"}},display:{defaultValue:null,description:"",name:"display",required:!1,type:{name:"ResponsiveProp<Display>"}},boxShadow:{defaultValue:null,description:"",name:"boxShadow",required:!1,type:{name:"ResponsiveProp<keyof ThemeShadows>"}},element:{defaultValue:null,description:"Sets the HTML element that will be rendered as a Box. Defaults to 'div'",name:"element",required:!1,type:{name:"ElementType"}},position:{defaultValue:null,description:"",name:"position",required:!1,type:{name:"ResponsiveProp<Position>"}},grow:{defaultValue:null,description:"Sets the property `flex-grow`",name:"grow",required:!1,type:{name:"ResponsiveProp<number>"}},shrink:{defaultValue:null,description:"Sets the property `flex-shrink`",name:"shrink",required:!1,type:{name:"ResponsiveProp<number>"}},basis:{defaultValue:null,description:"Sets the property `flex-basis`",name:"basis",required:!1,type:{name:"ResponsiveProp<FlexBasis>"}},flex:{defaultValue:null,description:"Sets the property `flex`",name:"flex",required:!1,type:{name:"ResponsiveProp<Flex>"}},minWidth:{defaultValue:null,description:"",name:"minWidth",required:!1,type:{name:"ResponsiveProp<MinWidth<number>>"}},maxWidth:{defaultValue:null,description:"",name:"maxWidth",required:!1,type:{name:"ResponsiveProp<MaxWidth<number>>"}},width:{defaultValue:null,description:"",name:"width",required:!1,type:{name:"ResponsiveProp<Width<number>>"}},minHeight:{defaultValue:null,description:"",name:"minHeight",required:!1,type:{name:"ResponsiveProp<MinHeight<number>>"}},maxHeight:{defaultValue:null,description:"",name:"maxHeight",required:!1,type:{name:"ResponsiveProp<MaxHeight<number>>"}},height:{defaultValue:null,description:"",name:"height",required:!1,type:{name:"ResponsiveProp<Height<number>>"}}}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/Layout/Box/Box.tsx#Box"]={docgenInfo:Box.__docgenInfo,name:"Box",path:"src/components/Layout/Box/Box.tsx#Box"})}catch(__react_docgen_typescript_loader_error){}},"./src/components/Layout/utils/responsiveness.tsx":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){function breakpointCSS(theme,prop,getCSS,key){const value=prop[key];if(null!=value)return{[theme.breakpoints.up(key)]:getCSS(value)}}function getResponsiveStyle(theme,prop,getCSS){return null==prop?null:"object"==typeof prop&&"xs"in prop?[breakpointCSS(theme,prop,getCSS,"xs"),breakpointCSS(theme,prop,getCSS,"sm"),breakpointCSS(theme,prop,getCSS,"md"),breakpointCSS(theme,prop,getCSS,"lg"),breakpointCSS(theme,prop,getCSS,"xl"),breakpointCSS(theme,prop,getCSS,"xxl")]:getCSS(prop)}__webpack_require__.d(__webpack_exports__,{Y:function(){return getResponsiveStyle}});try{getResponsiveStyle.displayName="getResponsiveStyle",getResponsiveStyle.__docgenInfo={description:"Function that converts a ResponsiveProp object into CSS",displayName:"getResponsiveStyle",props:{}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/Layout/utils/responsiveness.tsx#getResponsiveStyle"]={docgenInfo:getResponsiveStyle.__docgenInfo,name:"getResponsiveStyle",path:"src/components/Layout/utils/responsiveness.tsx#getResponsiveStyle"})}catch(__react_docgen_typescript_loader_error){}},"./src/components/Layout/utils/styles.ts":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.d(__webpack_exports__,{E:function(){return getSizeStyles}});var _emotion_css__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__("../../node_modules/@emotion/css/dist/emotion-css.esm.js"),_responsiveness__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__("./src/components/Layout/utils/responsiveness.tsx");const getSizeStyles=(theme,width,minWidth,maxWidth,height,minHeight,maxHeight)=>(0,_emotion_css__WEBPACK_IMPORTED_MODULE_0__.AH)([(0,_responsiveness__WEBPACK_IMPORTED_MODULE_1__.Y)(theme,width,(val=>({width:theme.spacing(val)}))),(0,_responsiveness__WEBPACK_IMPORTED_MODULE_1__.Y)(theme,minWidth,(val=>({minWidth:theme.spacing(val)}))),(0,_responsiveness__WEBPACK_IMPORTED_MODULE_1__.Y)(theme,maxWidth,(val=>({maxWidth:theme.spacing(val)}))),(0,_responsiveness__WEBPACK_IMPORTED_MODULE_1__.Y)(theme,height,(val=>({height:theme.spacing(val)}))),(0,_responsiveness__WEBPACK_IMPORTED_MODULE_1__.Y)(theme,minHeight,(val=>({minHeight:theme.spacing(val)}))),(0,_responsiveness__WEBPACK_IMPORTED_MODULE_1__.Y)(theme,maxHeight,(val=>({maxHeight:theme.spacing(val)})))])},"./src/components/Text/Text.tsx":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.d(__webpack_exports__,{E:function(){return Text}});var jsx_runtime=__webpack_require__("../../node_modules/react/jsx-runtime.js"),emotion_css_esm=__webpack_require__("../../node_modules/@emotion/css/dist/emotion-css.esm.js"),react=__webpack_require__("../../node_modules/react/index.js"),ThemeContext=__webpack_require__("./src/themes/ThemeContext.tsx"),server_browser=__webpack_require__("../../node_modules/react-dom/server.browser.js"),Tooltip=__webpack_require__("./src/components/Tooltip/Tooltip.tsx");const TruncatedText=react.forwardRef((({childElement:childElement,children:children},ref)=>{const[isOverflowing,setIsOverflowing]=(0,react.useState)(!1),internalRef=(0,react.useRef)(null);(0,react.useImperativeHandle)(ref,(()=>internalRef.current));const resizeObserver=(0,react.useMemo)((()=>new ResizeObserver((entries=>{for(const entry of entries)entry.target.clientWidth&&entry.target.scrollWidth&&(entry.target.scrollWidth>entry.target.clientWidth&&setIsOverflowing(!0),entry.target.scrollWidth<=entry.target.clientWidth&&setIsOverflowing(!1))}))),[]);(0,react.useEffect)((()=>{const{current:current}=internalRef;return current&&resizeObserver.observe(current),()=>{resizeObserver.disconnect()}}),[setIsOverflowing,resizeObserver]);const getTooltipText=children=>{if("string"==typeof children)return children;return server_browser.renderToStaticMarkup((0,jsx_runtime.jsx)(jsx_runtime.Fragment,{children:children})).replace(/(<([^>]+)>)/gi,"")};return isOverflowing?(0,jsx_runtime.jsx)(Tooltip.m,{ref:internalRef,content:getTooltipText(children),children:childElement(void 0)}):childElement(internalRef)}));TruncatedText.displayName="TruncatedText";try{TruncatedText.displayName="TruncatedText",TruncatedText.__docgenInfo={description:"",displayName:"TruncatedText",props:{childElement:{defaultValue:null,description:"",name:"childElement",required:!0,type:{name:"(ref: ForwardedRef<HTMLElement> | undefined) => ReactElement<any, string | JSXElementConstructor<any>>"}}}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/Text/TruncatedText.tsx#TruncatedText"]={docgenInfo:TruncatedText.__docgenInfo,name:"TruncatedText",path:"src/components/Text/TruncatedText.tsx#TruncatedText"})}catch(__react_docgen_typescript_loader_error){}var utils=__webpack_require__("./src/components/Text/utils.ts");const Text=react.forwardRef((({element:element="span",variant:variant,weight:weight,color:color,truncate:truncate,italic:italic,textAlignment:textAlignment,children:children,tabular:tabular,...restProps},ref)=>{const styles=(0,ThemeContext.of)(getTextStyles,element,variant,color,weight,truncate,italic,textAlignment,tabular),childElement=ref=>(0,react.createElement)(element,{...restProps,style:void 0,className:styles,ref:ref},children);return truncate&&"span"!==element?(0,jsx_runtime.jsx)(TruncatedText,{childElement:childElement,children:children,ref:ref}):childElement(void 0)}));Text.displayName="Text";const getTextStyles=(theme,element,variant,color,weight,truncate,italic,textAlignment,tabular)=>(0,emotion_css_esm.AH)([{margin:0,padding:0,...(0,utils.d$)(theme,element,variant)},variant&&{...theme.typography[variant]},color&&{color:(0,utils.vT)(color,theme)},weight&&{fontWeight:(0,utils.iV)(weight,theme)},truncate&&{overflow:"hidden",textOverflow:"ellipsis",whiteSpace:"nowrap"},italic&&{fontStyle:"italic"},textAlignment&&{textAlign:textAlignment},tabular&&{fontFeatureSettings:'"tnum"'}]);try{Text.displayName="Text",Text.__docgenInfo={description:"",displayName:"Text",props:{element:{defaultValue:{value:"span"},description:'Defines what HTML element is defined underneath. "span" by default',name:"element",required:!1,type:{name:"enum",value:[{value:'"h1"'},{value:'"h2"'},{value:'"h3"'},{value:'"h4"'},{value:'"h5"'},{value:'"h6"'},{value:'"li"'},{value:'"p"'},{value:'"span"'}]}},variant:{defaultValue:null,description:"What typograpy variant should be used for the component. Only use if default variant for the defined element is not what is needed",name:"variant",required:!1,type:{name:"enum",value:[{value:'"body"'},{value:'"code"'},{value:'"h1"'},{value:'"h2"'},{value:'"h3"'},{value:'"h4"'},{value:'"h5"'},{value:'"h6"'},{value:'"bodySmall"'}]}},weight:{defaultValue:null,description:"Override the default weight for the used variant",name:"weight",required:!1,type:{name:"enum",value:[{value:'"medium"'},{value:'"bold"'},{value:'"light"'},{value:'"regular"'}]}},color:{defaultValue:null,description:"Color to use for text",name:"color",required:!1,type:{name:"enum",value:[{value:'"info"'},{value:'"link"'},{value:'"primary"'},{value:'"secondary"'},{value:'"success"'},{value:'"error"'},{value:'"disabled"'},{value:'"warning"'},{value:'"maxContrast"'}]}},truncate:{defaultValue:null,description:"Use to cut the text off with ellipsis if there isn't space to show all of it. On hover shows the rest of the text",name:"truncate",required:!1,type:{name:"boolean"}},italic:{defaultValue:null,description:"If true, show the text as italic. False by default",name:"italic",required:!1,type:{name:"boolean"}},tabular:{defaultValue:null,description:"If true, numbers will have fixed width, useful for displaying tabular data. False by default",name:"tabular",required:!1,type:{name:"boolean"}},textAlignment:{defaultValue:null,description:"Whether to align the text to left, center or right",name:"textAlignment",required:!1,type:{name:"enum",value:[{value:'"right"'},{value:'"left"'},{value:'"start"'},{value:'"end"'},{value:'"center"'},{value:'"inherit"'},{value:'"-moz-initial"'},{value:'"initial"'},{value:'"revert"'},{value:'"revert-layer"'},{value:'"unset"'},{value:'"justify"'},{value:'"-webkit-match-parent"'},{value:'"match-parent"'}]}}}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/Text/Text.tsx#Text"]={docgenInfo:Text.__docgenInfo,name:"Text",path:"src/components/Text/Text.tsx#Text"})}catch(__react_docgen_typescript_loader_error){}},"./src/components/Text/utils.ts":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.d(__webpack_exports__,{d$:function(){return customVariant},iV:function(){return customWeight},vT:function(){return customColor}});const customWeight=(weight,theme)=>{switch(weight){case"bold":return theme.typography.fontWeightBold;case"medium":return theme.typography.fontWeightMedium;case"light":return theme.typography.fontWeightLight;case"regular":case void 0:return theme.typography.fontWeightRegular}},customColor=(color,theme)=>{switch(color){case"error":return theme.colors.error.text;case"success":return theme.colors.success.text;case"info":return theme.colors.info.text;case"warning":return theme.colors.warning.text;default:return color?theme.colors.text[color]:void 0}},customVariant=(theme,element,variant)=>{if(variant)return theme.typography[variant];switch(element){case"span":return;case"h1":return theme.typography.h1;case"h2":return theme.typography.h2;case"h3":return theme.typography.h3;case"h4":return theme.typography.h4;case"h5":return theme.typography.h5;case"h6":return theme.typography.h6;default:return theme.typography.body}}},"./src/components/FileDropzone/FileDropzone.story.tsx":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__),__webpack_require__.d(__webpack_exports__,{Basic:function(){return Basic},OnlyAcceptingCertainFiles:function(){return OnlyAcceptingCertainFiles},WithCustomFileList:function(){return WithCustomFileList},default:function(){return FileDropzone_story}});var jsx_runtime=__webpack_require__("../../node_modules/react/jsx-runtime.js"),emotion_css_esm=__webpack_require__("../../node_modules/@emotion/css/dist/emotion-css.esm.js"),lodash=__webpack_require__("../../node_modules/lodash/lodash.js"),react=__webpack_require__("../../node_modules/react/index.js"),es=__webpack_require__("../../node_modules/react-dropzone/dist/es/index.js"),valueFormats=__webpack_require__("../grafana-data/src/valueFormats/valueFormats.ts"),i18n=__webpack_require__("../grafana-i18n/src/i18n.tsx"),ThemeContext=__webpack_require__("./src/themes/ThemeContext.tsx"),Alert=__webpack_require__("./src/components/Alert/Alert.tsx"),Icon=__webpack_require__("./src/components/Icon/Icon.tsx"),FileListItem=__webpack_require__("./src/components/FileDropzone/FileListItem.tsx");function FileDropzone({options:options,children:children,readAs:readAs,onLoad:onLoad,fileListRenderer:fileListRenderer,onFileRemove:onFileRemove}){const[files,setFiles]=(0,react.useState)([]),[fileErrors,setErrorMessages]=(0,react.useState)([]),formattedSize=(0,valueFormats.j_)("decbytes")(options?.maxSize?options?.maxSize:0),setFileProperty=(0,react.useCallback)(((customFile,action)=>{setFiles((oldFiles=>oldFiles.map((oldFile=>oldFile.id===customFile.id?(action(oldFile),oldFile):oldFile))))}),[]),onDrop=(0,react.useCallback)(((acceptedFiles,rejectedFiles,event)=>{let customFiles=acceptedFiles.map(mapToCustomFile);if(setFiles(!1===options?.multiple?customFiles:oldFiles=>[...oldFiles,...customFiles]),setErrors(rejectedFiles),options?.onDrop)options.onDrop(acceptedFiles,rejectedFiles,event);else for(const customFile of customFiles){const reader=new FileReader,read=()=>{readAs?reader[readAs](customFile.file):reader.readAsText(customFile.file)};setFileProperty(customFile,(fileToModify=>{fileToModify.abortUpload=()=>{reader.abort()},fileToModify.retryUpload=()=>{setFileProperty(customFile,(fileToModify=>{fileToModify.error=null,fileToModify.progress=void 0})),read()}})),reader.onabort=()=>{setFileProperty(customFile,(fileToModify=>{fileToModify.error=new DOMException("Aborted")}))},reader.onprogress=event=>{setFileProperty(customFile,(fileToModify=>{fileToModify.progress=event.loaded}))},reader.onload=()=>{onLoad?.(reader.result)},reader.onerror=()=>{setFileProperty(customFile,(fileToModify=>{fileToModify.error=reader.error}))},read()}}),[onLoad,options,readAs,setFileProperty]),removeFile=file=>{const newFiles=files.filter((f=>file.id!==f.id));setFiles(newFiles),onFileRemove?.(file)},{getRootProps:getRootProps,getInputProps:getInputProps,isDragActive:isDragActive}=(0,es.VB)({...options,useFsAccessApi:!1,onDrop:onDrop,accept:transformAcceptToNewFormat(options?.accept)}),styles=getStyles((0,ThemeContext.$j)(),isDragActive),fileList=files.map((file=>fileListRenderer?fileListRenderer(file,removeFile):(0,jsx_runtime.jsx)(FileListItem.I,{file:file,removeFile:removeFile},file.id))),setErrors=rejectedFiles=>{let errors=[];rejectedFiles.map((rejectedFile=>{rejectedFile.errors.map((newError=>{-1===errors.findIndex((presentError=>presentError.code===newError.code&&presentError.message===newError.message))&&errors.push(newError)}))})),setErrorMessages(errors)},clearAlert=()=>{setErrorMessages([])};return(0,jsx_runtime.jsxs)("div",{className:styles.container,children:[(0,jsx_runtime.jsxs)("div",{"data-testid":"dropzone",...getRootProps({className:styles.dropzone}),children:[(0,jsx_runtime.jsx)("input",{...getInputProps()}),children??(0,jsx_runtime.jsx)(FileDropzoneDefaultChildren,{primaryText:getPrimaryText(files,options)})]}),fileErrors.length>0&&(errors=>{const size=(0,valueFormats.cN)(formattedSize);return(0,jsx_runtime.jsx)("div",{className:styles.errorAlert,children:(0,jsx_runtime.jsx)(Alert.F,{title:(0,i18n.t)("grafana-ui.file-dropzone.error-title","Upload failed"),severity:"error",onRemove:clearAlert,children:errors.map((error=>error.code===es.O4.FileTooLarge?(0,jsx_runtime.jsx)("div",{children:(0,jsx_runtime.jsxs)(i18n.x6,{i18nKey:"grafana-ui.file-dropzone.file-too-large",children:["File is larger than ",{size:size}]})},error.message+error.code):(0,jsx_runtime.jsx)("div",{children:error.message},error.message+error.code)))})})})(fileErrors),(0,jsx_runtime.jsxs)("small",{className:(0,emotion_css_esm.cx)(styles.small,styles.acceptContainer),children:[options?.maxSize&&`Max file size: ${(0,valueFormats.cN)(formattedSize)}`,options?.maxSize&&options?.accept&&(0,jsx_runtime.jsx)("span",{className:styles.acceptSeparator,children:"|"}),options?.accept&&getAcceptedFileTypeText(options.accept)]}),fileList]})}function getMimeTypeByExtension(ext){return["txt","json","csv","xls","yml"].some((e=>ext.match(e)))?"text/plain":"application/octet-stream"}function transformAcceptToNewFormat(accept){return(0,lodash.isString)(accept)?{[getMimeTypeByExtension(accept)]:[accept]}:Array.isArray(accept)?accept.reduce(((prev,current)=>{const mime=getMimeTypeByExtension(current);return prev[mime]=prev[mime]?[...prev[mime],current]:[current],prev}),{}):accept}function FileDropzoneDefaultChildren({primaryText:primaryText="Drop file here or click to upload",secondaryText:secondaryText=""}){const styles=getStyles((0,ThemeContext.$j)());return(0,jsx_runtime.jsxs)("div",{className:(0,emotion_css_esm.cx)(styles.defaultDropZone),"data-testid":"file-drop-zone-default-children",children:[(0,jsx_runtime.jsx)(Icon.I,{className:(0,emotion_css_esm.cx)(styles.icon),name:"upload",size:"xl"}),(0,jsx_runtime.jsx)("h6",{className:(0,emotion_css_esm.cx)(styles.primaryText),children:primaryText}),(0,jsx_runtime.jsx)("small",{className:styles.small,children:secondaryText})]})}function getPrimaryText(files,options){return void 0===options?.multiple||options?.multiple?"Upload file":files.length?"Replace file":"Upload file"}function getAcceptedFileTypeText(accept){return(0,lodash.isString)(accept)?`Accepted file type: ${accept}`:Array.isArray(accept)?`Accepted file types: ${accept.join(", ")}`:`Accepted file types: ${Object.values(accept).flat().join(", ")}`}function mapToCustomFile(file){return{id:(0,lodash.uniqueId)("file"),file:file,error:null}}function getStyles(theme,isDragActive){return{container:(0,emotion_css_esm.AH)({display:"flex",flexDirection:"column",width:"100%",padding:theme.spacing(2),borderRadius:theme.shape.radius.default,border:`1px dashed ${theme.colors.border.strong}`,backgroundColor:isDragActive?theme.colors.background.secondary:theme.colors.background.primary,cursor:"pointer",alignItems:"center",justifyContent:"center"}),dropzone:(0,emotion_css_esm.AH)({height:"100%",width:"100%",display:"flex",flexDirection:"column"}),defaultDropZone:(0,emotion_css_esm.AH)({textAlign:"center"}),icon:(0,emotion_css_esm.AH)({marginBottom:theme.spacing(1)}),primaryText:(0,emotion_css_esm.AH)({marginBottom:theme.spacing(1)}),acceptContainer:(0,emotion_css_esm.AH)({textAlign:"center",margin:0}),acceptSeparator:(0,emotion_css_esm.AH)({margin:`0 ${theme.spacing(1)}`}),small:(0,emotion_css_esm.AH)({color:theme.colors.text.secondary}),errorAlert:(0,emotion_css_esm.AH)({paddingTop:"10px"})}}try{FileDropzone.displayName="FileDropzone",FileDropzone.__docgenInfo={description:"",displayName:"FileDropzone",props:{children:{defaultValue:null,description:"Use the children property to have custom dropzone view.",name:"children",required:!1,type:{name:"ReactNode"}},options:{defaultValue:{value:"{\nmaxSize: Infinity,\nminSize: 0,\nmultiple: true,\nuseFsAccessApi: false,\nmaxFiles: 0,\n}"},description:"Use this property to override the default behaviour for the react-dropzone options.",name:"options",required:!1,type:{name:"BackwardsCompatibleDropzoneOptions"}},readAs:{defaultValue:null,description:"Use this to change the FileReader's read.",name:"readAs",required:!1,type:{name:"enum",value:[{value:'"readAsArrayBuffer"'},{value:'"readAsText"'},{value:'"readAsBinaryString"'},{value:'"readAsDataURL"'}]}},onLoad:{defaultValue:null,description:"Use the onLoad function to get the result from FileReader.",name:"onLoad",required:!1,type:{name:"((result: string | ArrayBuffer | null) => void)"}},fileListRenderer:{defaultValue:null,description:"The fileListRenderer property can be used to overwrite the list of files. To not to show\nany list return null in the function.",name:"fileListRenderer",required:!1,type:{name:"((file: DropzoneFile, removeFile: (file: DropzoneFile) => void) => ReactNode)"}},onFileRemove:{defaultValue:null,description:"",name:"onFileRemove",required:!1,type:{name:"((file: DropzoneFile) => void)"}}}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/FileDropzone/FileDropzone.tsx#FileDropzone"]={docgenInfo:FileDropzone.__docgenInfo,name:"FileDropzone",path:"src/components/FileDropzone/FileDropzone.tsx#FileDropzone"})}catch(__react_docgen_typescript_loader_error){}try{getMimeTypeByExtension.displayName="getMimeTypeByExtension",getMimeTypeByExtension.__docgenInfo={description:"",displayName:"getMimeTypeByExtension",props:{}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/FileDropzone/FileDropzone.tsx#getMimeTypeByExtension"]={docgenInfo:getMimeTypeByExtension.__docgenInfo,name:"getMimeTypeByExtension",path:"src/components/FileDropzone/FileDropzone.tsx#getMimeTypeByExtension"})}catch(__react_docgen_typescript_loader_error){}try{transformAcceptToNewFormat.displayName="transformAcceptToNewFormat",transformAcceptToNewFormat.__docgenInfo={description:"",displayName:"transformAcceptToNewFormat",props:{get:{defaultValue:null,description:"@deprecated Use [idx]. This only exists to help migrate Vector to Array",name:"get",required:!0,type:{name:"readonly string[] | ((idx: number) => string)"}},set:{defaultValue:null,description:"@deprecated Use [idx]. This only exists to help migrate Vector to Array",name:"set",required:!0,type:{name:"readonly string[] | ((idx: number, value: string) => void)"}},add:{defaultValue:null,description:"@deprecated Use .push(value). This only exists to help migrate Vector to Array",name:"add",required:!0,type:{name:"readonly string[] | ((value: string) => void)"}},toArray:{defaultValue:null,description:"@deprecated this is not necessary.  This only exists to help migrate Vector to Array",name:"toArray",required:!0,type:{name:"readonly string[] | (() => string[])"}}}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/FileDropzone/FileDropzone.tsx#transformAcceptToNewFormat"]={docgenInfo:transformAcceptToNewFormat.__docgenInfo,name:"transformAcceptToNewFormat",path:"src/components/FileDropzone/FileDropzone.tsx#transformAcceptToNewFormat"})}catch(__react_docgen_typescript_loader_error){}try{FileDropzoneDefaultChildren.displayName="FileDropzoneDefaultChildren",FileDropzoneDefaultChildren.__docgenInfo={description:"",displayName:"FileDropzoneDefaultChildren",props:{primaryText:{defaultValue:{value:"Drop file here or click to upload"},description:"",name:"primaryText",required:!1,type:{name:"string"}},secondaryText:{defaultValue:{value:""},description:"",name:"secondaryText",required:!1,type:{name:"string"}}}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/FileDropzone/FileDropzone.tsx#FileDropzoneDefaultChildren"]={docgenInfo:FileDropzoneDefaultChildren.__docgenInfo,name:"FileDropzoneDefaultChildren",path:"src/components/FileDropzone/FileDropzone.tsx#FileDropzoneDefaultChildren"})}catch(__react_docgen_typescript_loader_error){}var lib=__webpack_require__("../../node_modules/@storybook/addon-docs/node_modules/@mdx-js/react/lib/index.js"),dist=__webpack_require__("../../node_modules/@storybook/addon-docs/node_modules/@storybook/blocks/dist/index.mjs");function _createMdxContent(props){const _components={code:"code",h1:"h1",h3:"h3",p:"p",pre:"pre",...(0,lib.R)(),...props.components};return(0,jsx_runtime.jsxs)(jsx_runtime.Fragment,{children:[(0,jsx_runtime.jsx)(_components.h1,{id:"filedropzone",children:"FileDropzone"}),"\n",(0,jsx_runtime.jsx)(_components.p,{children:"A dropzone component to use for file uploads."}),"\n",(0,jsx_runtime.jsx)(_components.h3,{id:"usage",children:"Usage"}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-jsx",children:"import { FileDropzone } from '@grafana/ui';\n\n<FileDropzone onLoad={(result) => console.log(result)} />;\n"})}),"\n",(0,jsx_runtime.jsx)(_components.h3,{id:"props",children:"Props"}),"\n",(0,jsx_runtime.jsx)(dist.ov,{of:FileDropzone})]})}const meta={title:"Inputs/FileDropzone",component:FileDropzone,parameters:{docs:{page:function MDXContent(props={}){const{wrapper:MDXLayout}={...(0,lib.R)(),...props.components};return MDXLayout?(0,jsx_runtime.jsx)(MDXLayout,{...props,children:(0,jsx_runtime.jsx)(_createMdxContent,{...props})}):_createMdxContent(props)}}}},Template=args=>(0,jsx_runtime.jsx)(FileDropzone,{...args}),Basic=Template.bind({}),WithCustomFileList=Template.bind({});WithCustomFileList.args={fileListRenderer:file=>(0,jsx_runtime.jsxs)("div",{children:["Custom rendered item ",file.file.name]})};const OnlyAcceptingCertainFiles=Template.bind({});OnlyAcceptingCertainFiles.args={options:{accept:{"application/json":[".json"]}}};var FileDropzone_story=meta;Basic.parameters={...Basic.parameters,docs:{...Basic.parameters?.docs,source:{originalSource:"args => <FileDropzone {...args} />",...Basic.parameters?.docs?.source}}},WithCustomFileList.parameters={...WithCustomFileList.parameters,docs:{...WithCustomFileList.parameters?.docs,source:{originalSource:"args => <FileDropzone {...args} />",...WithCustomFileList.parameters?.docs?.source}}},OnlyAcceptingCertainFiles.parameters={...OnlyAcceptingCertainFiles.parameters,docs:{...OnlyAcceptingCertainFiles.parameters?.docs,source:{originalSource:"args => <FileDropzone {...args} />",...OnlyAcceptingCertainFiles.parameters?.docs?.source}}}}}]);