import uPlot, { Series } from 'uplot';
import { DataFrameFieldIndex, FieldColorMode, GrafanaTheme2, ThresholdsConfig } from '@grafana/data';
import { BarConfig, GraphDrawStyle, FillConfig, GraphGradientMode, LineConfig, PointsConfig } from '@grafana/schema';
import { PlotConfigBuilder } from '../types';
export interface SeriesProps extends LineConfig, BarConfig, FillConfig, PointsConfig {
    scaleKey: string;
    pxAlign?: boolean;
    gradientMode?: GraphGradientMode;
    dynamicSeriesColor?: (seriesIdx: number) => string | undefined;
    facets?: uPlot.Series.Facet[];
    /** Used when gradientMode is set to Scheme */
    thresholds?: ThresholdsConfig;
    colorMode?: FieldColorMode;
    hardMin?: number | null;
    hardMax?: number | null;
    softMin?: number | null;
    softMax?: number | null;
    drawStyle?: GraphDrawStyle;
    pathBuilder?: Series.PathBuilder | null;
    pointsFilter?: Series.Points.Filter | null;
    pointsBuilder?: Series.Points.Show | null;
    show?: boolean;
    dataFrameFieldIndex?: DataFrameFieldIndex;
    theme: GrafanaTheme2;
    value?: uPlot.Series.Value;
}
export declare class UPlotSeriesBuilder extends PlotConfigBuilder<SeriesProps, Series> {
    getConfig(): {
        show: boolean;
        class?: string;
        scale: string;
        auto?: boolean;
        sorted?: Series.Sorted;
        spanGaps: boolean;
        gaps?: Series.GapsRefiner;
        pxAlign: number | boolean;
        label?: string | HTMLElement;
        value: Series.Value;
        values?: Series.Values;
        paths?: Series.PathBuilder;
        points?: Series.Points;
        facets: Series.Facet[];
        width?: number;
        stroke?: Series.Stroke;
        fill: Series.Fill;
        fillTo?: Series.FillTo;
        dash?: number[];
        cap?: Series.Cap;
        alpha?: number;
        idxs?: Series.MinMaxIdxs;
        min?: number;
        max?: number;
    };
    private getLineColor;
    private getFill;
}
