import { DataFrame } from '@grafana/data';
import { FieldMatcherUIRegistryItem } from './types';
export interface Props {
    value?: string;
    data: DataFrame[];
    onChange: (value: string) => void;
    placeholder?: string;
}
export declare function RefIDPicker({ value, data, onChange, placeholder }: Props): import("react/jsx-runtime").JSX.Element;
export interface MultiProps {
    value?: string;
    data: DataFrame[];
    onChange: (value: string[]) => void;
    placeholder?: string;
}
export declare function RefIDMultiPicker({ value, data, onChange, placeholder }: MultiProps): import("react/jsx-runtime").JSX.Element;
/**
 * Registry item for UI to configure "fields by frame refId"-matcher.
 */
export declare const getFieldsByFrameRefIdItem: () => FieldMatcherUIRegistryItem<string>;
/** @internal */
export declare const regexpToStrings: (regexp: string) => string[];
/** @internal */
export declare const stringsToRegexp: (strings: string[]) => string;
