import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { Modal } from '../Modal/Modal.mjs';
import { ConfirmContent } from './ConfirmContent.mjs';

"use strict";
const ConfirmModal = ({
  isOpen,
  title,
  body,
  description,
  confirmText,
  confirmVariant = "destructive",
  confirmationText,
  dismissText = "Cancel",
  dismissVariant = "secondary",
  alternativeText,
  modalClass,
  icon = "exclamation-triangle",
  onConfirm,
  onDismiss,
  onAlternative,
  confirmButtonVariant = "destructive",
  disabled
}) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx(Modal, { className: cx(styles.modal, modalClass), title, icon, isOpen, onDismiss, children: /* @__PURE__ */ jsx(
    ConfirmContent,
    {
      body,
      description,
      confirmButtonLabel: confirmText,
      dismissButtonLabel: dismissText,
      dismissButtonVariant: dismissVariant,
      confirmPromptText: confirmationText,
      alternativeButtonLabel: alternativeText,
      confirmButtonVariant,
      onConfirm,
      onDismiss,
      onAlternative,
      disabled
    }
  ) });
};
const getStyles = () => ({
  modal: css({
    width: "500px"
  })
});

export { ConfirmModal };
//# sourceMappingURL=ConfirmModal.mjs.map
