import { type TypedUseMutationResult, type TypedUseQueryHookResult, fetchBaseQuery } from '@reduxjs/toolkit/query/react';
import { OverrideProperties } from 'type-fest';
import { CreateReceiverApiArg, type ListReceiverApiArg, alertingAPI } from '../../../api/v0alpha1/api.gen';
import type { ContactPoint, EnhancedListReceiverApiResponse } from '../../../api/v0alpha1/types';
type ListContactPointsHookResult = TypedUseQueryHookResult<EnhancedListReceiverApiResponse, ListReceiverApiArg, ReturnType<typeof fetchBaseQuery>>;
/**
 * useListContactPoints is a hook that fetches a list of contact points
 *
 * This function wraps the alertingAPI.useListReceiverQuery with proper typing
 * to ensure that the returned ContactPoints are correctly typed in the data.items array.
 *
 * It automatically uses the configured namespace for the query.
 */
export declare function useListContactPoints(): ListContactPointsHookResult & {
    refetch: () => import("@reduxjs/toolkit/query").QueryActionCreatorResult<import("@reduxjs/toolkit/query").QueryDefinition<ListReceiverApiArg, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("@reduxjs/toolkit/query").FetchArgs, unknown, import("@reduxjs/toolkit/query").FetchBaseQueryError, {}, import("@reduxjs/toolkit/query").FetchBaseQueryMeta>, "API Discovery" | "Receiver" | "RoutingTree" | "TemplateGroup" | "TimeInterval", import("../../../api/v0alpha1/api.gen").ReceiverList, `${string}/${string}`>>;
};
type CreateContactPointArgs = OverrideProperties<CreateReceiverApiArg, {
    receiver: Omit<ContactPoint, 'status' | 'metadata'>;
}>;
type CreateContactPointMutation = TypedUseMutationResult<ContactPoint, CreateContactPointArgs, ReturnType<typeof fetchBaseQuery>>;
type UseCreateContactPointOptions = Parameters<typeof alertingAPI.endpoints.createReceiver.useMutation<CreateContactPointMutation>>[0];
/**
 * useCreateContactPoint is a hook that creates a new contact point with one or more integrations
 *
 * This function wraps the alertingAPI.useCreateReceiverMutation with proper typing
 * to ensure that the payload supports type narrowing.
 */
export declare function useCreateContactPoint(options?: UseCreateContactPointOptions): readonly [(args: CreateContactPointArgs) => import("@reduxjs/toolkit/query").MutationActionCreatorResult<import("@reduxjs/toolkit/query").MutationDefinition<CreateReceiverApiArg, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("@reduxjs/toolkit/query").FetchArgs, unknown, import("@reduxjs/toolkit/query").FetchBaseQueryError, {}, import("@reduxjs/toolkit/query").FetchBaseQueryMeta>, "API Discovery" | "Receiver" | "RoutingTree" | "TemplateGroup" | "TimeInterval", import("../../../api/v0alpha1/api.gen").Receiver, `${string}/${string}`>>, ({
    requestId?: undefined;
    status: import("@reduxjs/toolkit/query").QueryStatus.uninitialized;
    data?: undefined;
    error?: undefined;
    endpointName?: string;
    startedTimeStamp?: undefined;
    fulfilledTimeStamp?: undefined;
} & {
    status: import("@reduxjs/toolkit/query").QueryStatus.uninitialized;
    isUninitialized: true;
    isLoading: false;
    isSuccess: false;
    isError: false;
} & {
    originalArgs?: {
        pretty?: string | undefined;
        dryRun?: string | undefined;
        fieldManager?: string | undefined;
        fieldValidation?: string | undefined;
        receiver: Omit<ContactPoint, "status" | "metadata">;
    } | undefined;
    reset: () => void;
} & {
    originalArgs?: CreateReceiverApiArg | undefined;
    reset: () => void;
}) | ({
    status: import("@reduxjs/toolkit/query").QueryStatus.fulfilled;
} & Omit<{
    requestId: string;
    data?: {
        apiVersion?: string | undefined;
        kind?: string | undefined;
        status: {
            additionalFields?: {
                [x: string]: object;
            } | undefined;
            operatorStates?: {
                [x: string]: {
                    descriptiveState?: string | undefined;
                    details?: {
                        [x: string]: object;
                    } | undefined;
                    lastEvaluation: string;
                    state: string;
                };
            } | undefined;
        };
        metadata: {
            creationTimestamp?: import("../../../api/v0alpha1/api.gen").Time | undefined;
            deletionGracePeriodSeconds?: number | undefined;
            deletionTimestamp?: import("../../../api/v0alpha1/api.gen").Time | undefined;
            finalizers?: string[] | undefined;
            generateName?: string | undefined;
            generation?: number | undefined;
            labels?: {
                [x: string]: string;
            } | undefined;
            managedFields?: import("../../../api/v0alpha1/api.gen").ManagedFieldsEntry[] | undefined;
            name?: string | undefined;
            namespace?: string | undefined;
            ownerReferences?: import("../../../api/v0alpha1/api.gen").OwnerReference[] | undefined;
            resourceVersion?: string | undefined;
            selfLink?: string | undefined;
            uid?: string | undefined;
            annotations: {
                'grafana.com/access/canAdmin'?: "false" | "true" | undefined;
                'grafana.com/access/canDelete'?: "false" | "true" | undefined;
                'grafana.com/access/canWrite'?: "false" | "true" | undefined;
                'grafana.com/provenance'?: string | undefined;
                'grafana.com/access/canReadSecrets'?: "false" | "true" | undefined;
                'grafana.com/inUse/routes'?: `${number}` | undefined;
                'grafana.com/inUse/rules'?: `${number}` | undefined;
            };
        };
        spec: {
            title: string;
            integrations: import("../../../../unstable").Integration[];
        };
    } | undefined;
    error?: import("@reduxjs/toolkit/query").FetchBaseQueryError | import("@reduxjs/toolkit").SerializedError | undefined;
    endpointName: string;
    startedTimeStamp: number;
    fulfilledTimeStamp?: number;
}, "data" | "fulfilledTimeStamp"> & Required<Pick<{
    requestId: string;
    data?: {
        apiVersion?: string | undefined;
        kind?: string | undefined;
        status: {
            additionalFields?: {
                [x: string]: object;
            } | undefined;
            operatorStates?: {
                [x: string]: {
                    descriptiveState?: string | undefined;
                    details?: {
                        [x: string]: object;
                    } | undefined;
                    lastEvaluation: string;
                    state: string;
                };
            } | undefined;
        };
        metadata: {
            creationTimestamp?: import("../../../api/v0alpha1/api.gen").Time | undefined;
            deletionGracePeriodSeconds?: number | undefined;
            deletionTimestamp?: import("../../../api/v0alpha1/api.gen").Time | undefined;
            finalizers?: string[] | undefined;
            generateName?: string | undefined;
            generation?: number | undefined;
            labels?: {
                [x: string]: string;
            } | undefined;
            managedFields?: import("../../../api/v0alpha1/api.gen").ManagedFieldsEntry[] | undefined;
            name?: string | undefined;
            namespace?: string | undefined;
            ownerReferences?: import("../../../api/v0alpha1/api.gen").OwnerReference[] | undefined;
            resourceVersion?: string | undefined;
            selfLink?: string | undefined;
            uid?: string | undefined;
            annotations: {
                'grafana.com/access/canAdmin'?: "false" | "true" | undefined;
                'grafana.com/access/canDelete'?: "false" | "true" | undefined;
                'grafana.com/access/canWrite'?: "false" | "true" | undefined;
                'grafana.com/provenance'?: string | undefined;
                'grafana.com/access/canReadSecrets'?: "false" | "true" | undefined;
                'grafana.com/inUse/routes'?: `${number}` | undefined;
                'grafana.com/inUse/rules'?: `${number}` | undefined;
            };
        };
        spec: {
            title: string;
            integrations: import("../../../../unstable").Integration[];
        };
    } | undefined;
    error?: import("@reduxjs/toolkit/query").FetchBaseQueryError | import("@reduxjs/toolkit").SerializedError | undefined;
    endpointName: string;
    startedTimeStamp: number;
    fulfilledTimeStamp?: number;
}, "data" | "fulfilledTimeStamp">> & {
    error: undefined;
} & {
    status: import("@reduxjs/toolkit/query").QueryStatus.fulfilled;
    isUninitialized: false;
    isLoading: false;
    isSuccess: true;
    isError: false;
} & {
    originalArgs?: {
        pretty?: string | undefined;
        dryRun?: string | undefined;
        fieldManager?: string | undefined;
        fieldValidation?: string | undefined;
        receiver: Omit<ContactPoint, "status" | "metadata">;
    } | undefined;
    reset: () => void;
} & {
    originalArgs?: CreateReceiverApiArg | undefined;
    reset: () => void;
}) | ({
    status: import("@reduxjs/toolkit/query").QueryStatus.pending;
} & {
    requestId: string;
    data?: {
        apiVersion?: string | undefined;
        kind?: string | undefined;
        status: {
            additionalFields?: {
                [x: string]: object;
            } | undefined;
            operatorStates?: {
                [x: string]: {
                    descriptiveState?: string | undefined;
                    details?: {
                        [x: string]: object;
                    } | undefined;
                    lastEvaluation: string;
                    state: string;
                };
            } | undefined;
        };
        metadata: {
            creationTimestamp?: import("../../../api/v0alpha1/api.gen").Time | undefined;
            deletionGracePeriodSeconds?: number | undefined;
            deletionTimestamp?: import("../../../api/v0alpha1/api.gen").Time | undefined;
            finalizers?: string[] | undefined;
            generateName?: string | undefined;
            generation?: number | undefined;
            labels?: {
                [x: string]: string;
            } | undefined;
            managedFields?: import("../../../api/v0alpha1/api.gen").ManagedFieldsEntry[] | undefined;
            name?: string | undefined;
            namespace?: string | undefined;
            ownerReferences?: import("../../../api/v0alpha1/api.gen").OwnerReference[] | undefined;
            resourceVersion?: string | undefined;
            selfLink?: string | undefined;
            uid?: string | undefined;
            annotations: {
                'grafana.com/access/canAdmin'?: "false" | "true" | undefined;
                'grafana.com/access/canDelete'?: "false" | "true" | undefined;
                'grafana.com/access/canWrite'?: "false" | "true" | undefined;
                'grafana.com/provenance'?: string | undefined;
                'grafana.com/access/canReadSecrets'?: "false" | "true" | undefined;
                'grafana.com/inUse/routes'?: `${number}` | undefined;
                'grafana.com/inUse/rules'?: `${number}` | undefined;
            };
        };
        spec: {
            title: string;
            integrations: import("../../../../unstable").Integration[];
        };
    } | undefined;
    error?: import("@reduxjs/toolkit/query").FetchBaseQueryError | import("@reduxjs/toolkit").SerializedError | undefined;
    endpointName: string;
    startedTimeStamp: number;
    fulfilledTimeStamp?: number;
} & {
    data?: undefined;
} & {
    status: import("@reduxjs/toolkit/query").QueryStatus.pending;
    isUninitialized: false;
    isLoading: true;
    isSuccess: false;
    isError: false;
} & {
    originalArgs?: {
        pretty?: string | undefined;
        dryRun?: string | undefined;
        fieldManager?: string | undefined;
        fieldValidation?: string | undefined;
        receiver: Omit<ContactPoint, "status" | "metadata">;
    } | undefined;
    reset: () => void;
} & {
    originalArgs?: CreateReceiverApiArg | undefined;
    reset: () => void;
}) | ({
    status: import("@reduxjs/toolkit/query").QueryStatus.rejected;
} & Omit<{
    requestId: string;
    data?: {
        apiVersion?: string | undefined;
        kind?: string | undefined;
        status: {
            additionalFields?: {
                [x: string]: object;
            } | undefined;
            operatorStates?: {
                [x: string]: {
                    descriptiveState?: string | undefined;
                    details?: {
                        [x: string]: object;
                    } | undefined;
                    lastEvaluation: string;
                    state: string;
                };
            } | undefined;
        };
        metadata: {
            creationTimestamp?: import("../../../api/v0alpha1/api.gen").Time | undefined;
            deletionGracePeriodSeconds?: number | undefined;
            deletionTimestamp?: import("../../../api/v0alpha1/api.gen").Time | undefined;
            finalizers?: string[] | undefined;
            generateName?: string | undefined;
            generation?: number | undefined;
            labels?: {
                [x: string]: string;
            } | undefined;
            managedFields?: import("../../../api/v0alpha1/api.gen").ManagedFieldsEntry[] | undefined;
            name?: string | undefined;
            namespace?: string | undefined;
            ownerReferences?: import("../../../api/v0alpha1/api.gen").OwnerReference[] | undefined;
            resourceVersion?: string | undefined;
            selfLink?: string | undefined;
            uid?: string | undefined;
            annotations: {
                'grafana.com/access/canAdmin'?: "false" | "true" | undefined;
                'grafana.com/access/canDelete'?: "false" | "true" | undefined;
                'grafana.com/access/canWrite'?: "false" | "true" | undefined;
                'grafana.com/provenance'?: string | undefined;
                'grafana.com/access/canReadSecrets'?: "false" | "true" | undefined;
                'grafana.com/inUse/routes'?: `${number}` | undefined;
                'grafana.com/inUse/rules'?: `${number}` | undefined;
            };
        };
        spec: {
            title: string;
            integrations: import("../../../../unstable").Integration[];
        };
    } | undefined;
    error?: import("@reduxjs/toolkit/query").FetchBaseQueryError | import("@reduxjs/toolkit").SerializedError | undefined;
    endpointName: string;
    startedTimeStamp: number;
    fulfilledTimeStamp?: number;
}, "error"> & Required<Pick<{
    requestId: string;
    data?: {
        apiVersion?: string | undefined;
        kind?: string | undefined;
        status: {
            additionalFields?: {
                [x: string]: object;
            } | undefined;
            operatorStates?: {
                [x: string]: {
                    descriptiveState?: string | undefined;
                    details?: {
                        [x: string]: object;
                    } | undefined;
                    lastEvaluation: string;
                    state: string;
                };
            } | undefined;
        };
        metadata: {
            creationTimestamp?: import("../../../api/v0alpha1/api.gen").Time | undefined;
            deletionGracePeriodSeconds?: number | undefined;
            deletionTimestamp?: import("../../../api/v0alpha1/api.gen").Time | undefined;
            finalizers?: string[] | undefined;
            generateName?: string | undefined;
            generation?: number | undefined;
            labels?: {
                [x: string]: string;
            } | undefined;
            managedFields?: import("../../../api/v0alpha1/api.gen").ManagedFieldsEntry[] | undefined;
            name?: string | undefined;
            namespace?: string | undefined;
            ownerReferences?: import("../../../api/v0alpha1/api.gen").OwnerReference[] | undefined;
            resourceVersion?: string | undefined;
            selfLink?: string | undefined;
            uid?: string | undefined;
            annotations: {
                'grafana.com/access/canAdmin'?: "false" | "true" | undefined;
                'grafana.com/access/canDelete'?: "false" | "true" | undefined;
                'grafana.com/access/canWrite'?: "false" | "true" | undefined;
                'grafana.com/provenance'?: string | undefined;
                'grafana.com/access/canReadSecrets'?: "false" | "true" | undefined;
                'grafana.com/inUse/routes'?: `${number}` | undefined;
                'grafana.com/inUse/rules'?: `${number}` | undefined;
            };
        };
        spec: {
            title: string;
            integrations: import("../../../../unstable").Integration[];
        };
    } | undefined;
    error?: import("@reduxjs/toolkit/query").FetchBaseQueryError | import("@reduxjs/toolkit").SerializedError | undefined;
    endpointName: string;
    startedTimeStamp: number;
    fulfilledTimeStamp?: number;
}, "error">> & {
    status: import("@reduxjs/toolkit/query").QueryStatus.rejected;
    isUninitialized: false;
    isLoading: false;
    isSuccess: false;
    isError: true;
} & {
    originalArgs?: {
        pretty?: string | undefined;
        dryRun?: string | undefined;
        fieldManager?: string | undefined;
        fieldValidation?: string | undefined;
        receiver: Omit<ContactPoint, "status" | "metadata">;
    } | undefined;
    reset: () => void;
} & {
    originalArgs?: CreateReceiverApiArg | undefined;
    reset: () => void;
})];
export {};
