import uFuzzy from '@leeoniya/ufuzzy';
import { escapeRegex } from '../text/string.mjs';

"use strict";
const REGEXP_NON_ASCII = /[^ -~]/m;
const REGEXP_ONLY_SYMBOLS = /^[\x21-\x2F\x3A-\x40\x5B-\x60\x7B-\x7E]+$/m;
const outOfOrderLimit = 5;
const maxNeedleLength = 25;
const maxFuzzyTerms = 5;
const rankThreshold = 1e4;
const uf = new uFuzzy({ intraMode: 1 });
function fuzzySearch(haystack, needle) {
  if (needle === "") {
    return haystack.map((_, index) => index);
  } else if (
    // contains non-ascii
    REGEXP_NON_ASCII.test(needle) || // is only ascii symbols (operators)
    REGEXP_ONLY_SYMBOLS.test(needle) || // too long (often copy-paste from somewhere)
    needle.length > maxNeedleLength || uf.split(needle).length > maxFuzzyTerms
  ) {
    const needleRegex = new RegExp(escapeRegex(needle), "i");
    const indices = [];
    for (let i = 0; i < haystack.length; i++) {
      let item = haystack[i];
      if (needleRegex.test(item)) {
        indices.push(i);
      }
    }
    return indices;
  } else {
    const [idxs, info, order] = uf.search(haystack, needle, outOfOrderLimit, rankThreshold);
    if (idxs == null ? void 0 : idxs.length) {
      if (info && order) {
        return order.map((idx) => info.idx[idx]);
      } else {
        return idxs;
      }
    }
  }
  return [];
}

export { fuzzySearch };
//# sourceMappingURL=fuzzySearch.mjs.map
