import { DataTransformerConfig } from '@grafana/schema';
import { FieldConfigSource } from './fieldOverrides';
import { DataQuery, DataSourceRef } from './query';
export declare enum DashboardCursorSync {
    Off = 0,
    Crosshair = 1,
    Tooltip = 2
}
/**
 * @public
 */
export interface PanelModel<TOptions = any, TCustomFieldConfig = any> {
    /** ID of the panel within the current dashboard */
    id: number;
    /** The panel type */
    type: string;
    /** Panel title */
    title?: string;
    /** Description */
    description?: string;
    /** Panel options */
    options: TOptions;
    /** Field options configuration */
    fieldConfig: FieldConfigSource<TCustomFieldConfig>;
    /** Version of the panel plugin */
    pluginVersion?: string;
    /** The datasource used in all targets */
    datasource?: DataSourceRef | null;
    /** The queries in a panel */
    targets?: DataQuery[];
    /** Optionally process data after query */
    transformations?: DataTransformerConfig[];
    /** alerting v1 object */
    alert?: any;
}
