import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { flip, shift, useFloating, useDismiss, useInteractions } from '@floating-ui/react';
import { useMemo } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { Portal } from '../Portal/Portal.mjs';
import { VizTooltipFooter } from '../VizTooltip/VizTooltipFooter.mjs';
import { VizTooltipWrapper } from '../VizTooltip/VizTooltipWrapper.mjs';

"use strict";
const DataLinksActionsTooltip = ({ links, actions, value, coords, onTooltipClose }) => {
  const styles = useStyles2(getStyles);
  const middleware = [
    flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    shift()
  ];
  const virtual = useMemo(() => {
    const { clientX, clientY } = coords;
    return {
      getBoundingClientRect() {
        return {
          width: 0,
          height: 0,
          x: clientX,
          y: clientY,
          top: clientY,
          left: clientX,
          right: clientX,
          bottom: clientY
        };
      }
    };
  }, [coords]);
  const refCallback = (el) => {
    refs.setFloating(el);
    refs.setReference(virtual);
  };
  const { context, refs, floatingStyles } = useFloating({
    open: true,
    placement: "right-start",
    onOpenChange: onTooltipClose,
    middleware
    // whileElementsMounted: autoUpdate,
  });
  const dismiss = useDismiss(context);
  const { getFloatingProps, getReferenceProps } = useInteractions([dismiss]);
  if (links.length === 0 && !Boolean(actions == null ? void 0 : actions.length)) {
    return null;
  }
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    value,
    /* @__PURE__ */ jsx(Portal, { children: /* @__PURE__ */ jsx(
      "div",
      {
        ref: refCallback,
        ...getReferenceProps(),
        ...getFloatingProps(),
        style: floatingStyles,
        className: styles.tooltipWrapper,
        "data-testid": selectors.components.DataLinksActionsTooltip.tooltipWrapper,
        children: /* @__PURE__ */ jsx(VizTooltipWrapper, { children: /* @__PURE__ */ jsx(VizTooltipFooter, { dataLinks: links, actions }) })
      }
    ) })
  ] });
};
const renderSingleLink = (link, children, className) => {
  return /* @__PURE__ */ jsx(
    "a",
    {
      href: link.href,
      onClick: link.onClick,
      target: link.target,
      title: link.title,
      "data-testid": selectors.components.DataLinksContextMenu.singleLink,
      className,
      children
    }
  );
};
const getStyles = (theme) => {
  return {
    tooltipWrapper: css({
      zIndex: theme.zIndex.portal,
      whiteSpace: "pre",
      borderRadius: theme.shape.radius.default,
      background: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      boxShadow: theme.shadows.z3,
      userSelect: "text",
      fontSize: theme.typography.bodySmall.fontSize
    })
  };
};

export { DataLinksActionsTooltip, renderSingleLink };
//# sourceMappingURL=DataLinksActionsTooltip.mjs.map
