import { jsx } from 'react/jsx-runtime';
import { memo, useCallback } from 'react';
import { SeriesColorPicker } from '../ColorPicker/ColorPicker.mjs';
import '../PanelChrome/index.mjs';
import { SeriesIcon } from './SeriesIcon.mjs';
import { usePanelContext } from '../PanelChrome/PanelContext.mjs';

"use strict";
const VizLegendSeriesIcon = memo(({ seriesName, color, gradient, readonly, lineStyle }) => {
  const { onSeriesColorChange } = usePanelContext();
  const onChange = useCallback(
    (color2) => {
      return onSeriesColorChange(seriesName, color2);
    },
    [seriesName, onSeriesColorChange]
  );
  if (seriesName && onSeriesColorChange && color && !readonly) {
    return /* @__PURE__ */ jsx(SeriesColorPicker, { color, onChange, enableNamedColors: true, children: ({ ref, showColorPicker, hideColorPicker }) => /* @__PURE__ */ jsx(
      SeriesIcon,
      {
        color,
        className: "pointer",
        ref,
        onClick: showColorPicker,
        onMouseLeave: hideColorPicker,
        lineStyle
      }
    ) });
  }
  return /* @__PURE__ */ jsx(SeriesIcon, { color, gradient, lineStyle });
});
VizLegendSeriesIcon.displayName = "VizLegendSeriesIcon";

export { VizLegendSeriesIcon };
//# sourceMappingURL=VizLegendSeriesIcon.mjs.map
