import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';
import { renderSingleLink } from '../../DataLinksActionsTooltip.mjs';
import '../../types.mjs';
import { useSingleLink } from '../hooks.mjs';
import { TableCellDisplayMode } from '@grafana/schema';

"use strict";
const DATALINKS_HEIGHT_OFFSET = 10;
const ImageCell = ({ cellOptions, field, height, justifyContent, value, rowIdx }) => {
  const calculatedHeight = height - DATALINKS_HEIGHT_OFFSET;
  const styles = useStyles2(getStyles, calculatedHeight, justifyContent);
  const { text } = field.display(value);
  const { alt, title } = cellOptions.type === TableCellDisplayMode.Image ? cellOptions : { alt: void 0, title: void 0 };
  const img = /* @__PURE__ */ jsx("img", { alt, src: text, className: styles.image, title });
  const link = useSingleLink(field, rowIdx);
  return /* @__PURE__ */ jsx("div", { className: styles.imageContainer, children: link == null ? img : renderSingleLink(link, img) });
};
const getStyles = (theme, height, justifyContent) => ({
  image: css({
    height,
    width: "auto"
  }),
  imageContainer: css({
    display: "flex",
    justifyContent
  })
});

export { ImageCell };
//# sourceMappingURL=ImageCell.mjs.map
