import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { Trans, t } from '@grafana/i18n';
import { InlineSwitch } from '../Switch/Switch.mjs';
import { InlineField } from '../Forms/InlineField.mjs';

"use strict";
function AlertingSettings({ options, onOptionsChange }) {
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("h3", { className: "page-heading", children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.data-source-settings.alerting-settings-heading", children: "Alerting" }) }),
    /* @__PURE__ */ jsx("div", { className: "gf-form-group", children: /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
      InlineField,
      {
        labelWidth: 29,
        label: t("grafana-ui.data-source-settings.alerting-settings-label", "Manage alert rules in Alerting UI"),
        disabled: options.readOnly,
        tooltip: t(
          "grafana-ui.data-source-settings.alerting-settings-tooltip",
          "Manage alert rules for this data source. To manage other alerting resources, add an Alertmanager data source."
        ),
        children: /* @__PURE__ */ jsx(
          InlineSwitch,
          {
            value: options.jsonData.manageAlerts !== false,
            onChange: (event) => onOptionsChange({
              ...options,
              jsonData: { ...options.jsonData, manageAlerts: event.currentTarget.checked }
            })
          }
        )
      }
    ) }) }) })
  ] });
}

export { AlertingSettings };
//# sourceMappingURL=AlertingSettings.mjs.map
