import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { useState } from 'react';
import { Trans } from '@grafana/i18n';
import { Button } from '../../Button/Button.mjs';
import { Modal } from '../../Modal/Modal.mjs';
import { DataLinkEditor } from '../DataLinkEditor.mjs';

"use strict";
const DataLinkEditorModalContent = ({
  link,
  index,
  onSave,
  onCancel,
  getSuggestions,
  showOneClick
}) => {
  const [dirtyLink, setDirtyLink] = useState(link);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      DataLinkEditor,
      {
        value: dirtyLink,
        index,
        isLast: false,
        onChange: (index2, link2) => {
          setDirtyLink(link2);
        },
        suggestions: getSuggestions(),
        showOneClick
      }
    ),
    /* @__PURE__ */ jsxs(Modal.ButtonRow, { children: [
      /* @__PURE__ */ jsx(Button, { variant: "secondary", onClick: () => onCancel(index), fill: "outline", children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.data-link-editor-modal.cancel", children: "Cancel" }) }),
      /* @__PURE__ */ jsx(
        Button,
        {
          onClick: () => {
            onSave(index, dirtyLink);
          },
          disabled: dirtyLink.title.trim() === "" || dirtyLink.url.trim() === "",
          children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.data-link-editor-modal.save", children: "Save" })
        }
      )
    ] })
  ] });
};

export { DataLinkEditorModalContent };
//# sourceMappingURL=DataLinkEditorModalContent.mjs.map
