import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

"use strict";
const FullWidthButtonContainer = ({ className, children }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { className: cx(styles, className), children });
};
const getStyles = () => css({
  display: "flex",
  button: {
    flexGrow: 1,
    justifyContent: "center"
  },
  "> *": {
    flexGrow: 1
  },
  label: {
    flexGrow: 1,
    textAlign: "center"
  }
});

export { FullWidthButtonContainer };
//# sourceMappingURL=FullWidthButtonContainer.mjs.map
