import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { getResponsiveStyle } from '../Layout/utils/responsiveness.mjs';

"use strict";
const Avatar = ({ src, alt, width, height }) => {
  const styles = useStyles2(getStyles, width, height);
  return /* @__PURE__ */ jsx("img", { className: styles.image, src, alt });
};
const getStyles = (theme, width = 3, height = 3) => {
  return {
    image: css([
      getResponsiveStyle(theme, width, (val) => ({
        width: theme.spacing(val)
      })),
      getResponsiveStyle(theme, height, (val) => ({
        height: theme.spacing(val)
      })),
      { borderRadius: theme.shape.radius.circle }
    ])
  };
};

export { Avatar };
//# sourceMappingURL=Avatar.mjs.map
