import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useState, useMemo } from 'react';
import { RgbaStringColorPicker } from 'react-colorful';
import { useThrottleFn } from 'react-use';
import tinycolor from 'tinycolor2';
import { colorManipulator } from '@grafana/data';
import { useTheme2, useStyles2 } from '../../themes/ThemeContext.mjs';
import ColorInput from './ColorInput.mjs';

"use strict";
const SpectrumPalette = ({ color, onChange }) => {
  const [currentColor, setColor] = useState(color);
  useThrottleFn(
    (c) => {
      onChange(colorManipulator.asHexString(theme.visualization.getColorByName(c)));
    },
    500,
    [currentColor]
  );
  const theme = useTheme2();
  const styles = useStyles2(getStyles);
  const rgbaString = useMemo(() => {
    return currentColor.startsWith("rgba") ? currentColor : tinycolor(theme.visualization.getColorByName(color)).toRgbString();
  }, [currentColor, theme, color]);
  return /* @__PURE__ */ jsxs("div", { className: styles.wrapper, children: [
    /* @__PURE__ */ jsx(RgbaStringColorPicker, { className: styles.root, color: rgbaString, onChange: setColor }),
    /* @__PURE__ */ jsx(ColorInput, { theme, color: rgbaString, onChange: setColor, className: styles.colorInput })
  ] });
};
const getStyles = (theme) => ({
  wrapper: css({
    flexGrow: 1
  }),
  root: css({
    "&.react-colorful": {
      width: "auto"
    },
    ".react-colorful": {
      "&__saturation": {
        borderRadius: `${theme.shape.radius.default} ${theme.shape.radius.default} 0 0`
      },
      "&__alpha": {
        borderRadius: `0 0 ${theme.shape.radius.default} ${theme.shape.radius.default}`
      },
      "&__alpha, &__hue": {
        height: theme.spacing(2),
        position: "relative"
      },
      "&__pointer": {
        height: theme.spacing(2),
        width: theme.spacing(2)
      }
    }
  }),
  colorInput: css({
    marginTop: theme.spacing(2)
  })
});

export { SpectrumPalette as default, getStyles };
//# sourceMappingURL=SpectrumPalette.mjs.map
