import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { t } from '@grafana/i18n';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { Button } from '../Button/Button.mjs';
import { Field } from '../Forms/Field.mjs';
import { FieldSet } from '../Forms/FieldSet.mjs';
import { Input } from '../Input/Input.mjs';
import { Modal } from '../Modal/Modal.mjs';

"use strict";
function VariablesInputModal({ action, onDismiss, onShowConfirm, variables, setVariables }) {
  const styles = useStyles2(getStyles);
  const onModalContinue = () => {
    onDismiss();
    onShowConfirm();
  };
  return /* @__PURE__ */ jsxs(
    Modal,
    {
      isOpen: true,
      title: t("grafana-ui.action-editor.button.action-variables-title", "Action variables"),
      onDismiss,
      className: styles.variablesModal,
      children: [
        /* @__PURE__ */ jsx(FieldSet, { children: action.variables.map((variable) => {
          var _a;
          return /* @__PURE__ */ jsx(Field, { label: variable.name, children: /* @__PURE__ */ jsx(
            Input,
            {
              type: "text",
              value: (_a = variables[variable.key]) != null ? _a : "",
              onChange: (e) => {
                setVariables({ ...variables, [variable.key]: e.currentTarget.value });
              },
              placeholder: t("grafana-ui.action-editor.button.variable-value-placeholder", "Value"),
              width: 20
            }
          ) }, variable.name);
        }) }),
        /* @__PURE__ */ jsxs(Modal.ButtonRow, { children: [
          /* @__PURE__ */ jsx(Button, { variant: "secondary", onClick: onDismiss, children: t("grafana-ui.action-editor.close", "Close") }),
          /* @__PURE__ */ jsx(Button, { variant: "primary", onClick: onModalContinue, children: t("grafana-ui.action-editor.continue", "Continue") })
        ] })
      ]
    }
  );
}
const getStyles = () => {
  return {
    variablesModal: css({
      zIndex: 1e4
    })
  };
};

export { VariablesInputModal };
//# sourceMappingURL=VariablesInputModal.mjs.map
