import * as React from 'react';
import { ClickedItemData, ColorScheme, ColorSchemeDiff, SelectedView, TextAlign } from '../types';
import { GetExtraContextMenuButtonsFunction } from './FlameGraphContextMenu';
import { CollapsedMap, FlameGraphDataContainer } from './dataTransform';
type Props = {
    data: FlameGraphDataContainer;
    rangeMin: number;
    rangeMax: number;
    matchedLabels?: Set<string>;
    setRangeMin: (range: number) => void;
    setRangeMax: (range: number) => void;
    style?: React.CSSProperties;
    onItemFocused: (data: ClickedItemData) => void;
    focusedItemData?: ClickedItemData;
    textAlign: TextAlign;
    sandwichItem?: string;
    onSandwich: (label: string) => void;
    onFocusPillClick: () => void;
    onSandwichPillClick: () => void;
    colorScheme: ColorScheme | ColorSchemeDiff;
    showFlameGraphOnly?: boolean;
    getExtraContextMenuButtons?: GetExtraContextMenuButtonsFunction;
    collapsing?: boolean;
    selectedView: SelectedView;
    search: string;
    collapsedMap: CollapsedMap;
    setCollapsedMap: (collapsedMap: CollapsedMap) => void;
};
declare const FlameGraph: ({ data, rangeMin, rangeMax, matchedLabels, setRangeMin, setRangeMax, onItemFocused, focusedItemData, textAlign, onSandwich, sandwichItem, onFocusPillClick, onSandwichPillClick, colorScheme, showFlameGraphOnly, getExtraContextMenuButtons, collapsing, selectedView, search, collapsedMap, setCollapsedMap, }: Props) => import("react/jsx-runtime").JSX.Element | null;
export default FlameGraph;
