import { map } from 'rxjs/operators';
import { cacheFieldDisplayNames } from '../../field/fieldState.mjs';
import { TransformationApplicabilityLevels } from '../../types/transformations.mjs';
import { fieldToStringField } from './convertFieldType.mjs';
import { DataTransformerID } from './ids.mjs';

"use strict";
const formatTimeTransformer = {
  id: DataTransformerID.formatTime,
  name: "Format time",
  description: "Set the output format of a time field",
  defaultOptions: { timeField: "", outputFormat: "", useTimezone: true },
  isApplicable: (data) => {
    for (const frame of data) {
      for (const field of frame.fields) {
        if (field.type === "time") {
          return TransformationApplicabilityLevels.Applicable;
        }
      }
    }
    return TransformationApplicabilityLevels.NotApplicable;
  },
  isApplicableDescription: "The Format time transformation requires a time field to work. No time field could be found.",
  operator: (options, ctx) => (source) => source.pipe(
    map((data) => {
      return applyFormatTime(options, data, ctx);
    })
  )
};
const applyFormatTime = ({ timeField, outputFormat, timezone }, data, ctx) => {
  var _a;
  if (!Array.isArray(data) || data.length === 0) {
    return data;
  }
  cacheFieldDisplayNames(data);
  outputFormat = (_a = ctx == null ? void 0 : ctx.interpolate(outputFormat)) != null ? _a : outputFormat;
  return data.map((frame) => ({
    ...frame,
    fields: frame.fields.map((field) => {
      var _a2;
      if (((_a2 = field.state) == null ? void 0 : _a2.displayName) === timeField) {
        field = fieldToStringField(field, outputFormat, { timeZone: timezone });
      }
      return field;
    })
  }));
};

export { applyFormatTime, formatTimeTransformer };
//# sourceMappingURL=formatTime.mjs.map
