import { jsx, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useToggle } from 'react-use';
import { useStyles2, Collapse, Stack } from '@grafana/ui';

"use strict";
function QueryOptionGroup({ title, children, collapsedInfo }) {
  const [isOpen, toggleOpen] = useToggle(false);
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { className: styles.wrapper, children: /* @__PURE__ */ jsx(
    Collapse,
    {
      className: styles.collapse,
      collapsible: true,
      isOpen,
      onToggle: toggleOpen,
      label: /* @__PURE__ */ jsxs(Stack, { gap: 0, children: [
        /* @__PURE__ */ jsx("h6", { className: styles.title, children: title }),
        !isOpen && /* @__PURE__ */ jsx("div", { className: styles.description, children: collapsedInfo.map((x, i) => /* @__PURE__ */ jsx("span", { children: x }, i)) })
      ] }),
      children: /* @__PURE__ */ jsx("div", { className: styles.body, children })
    }
  ) });
}
const getStyles = (theme) => {
  return {
    collapse: css({
      backgroundColor: "unset",
      border: "unset",
      marginBottom: 0,
      ["> button"]: {
        padding: theme.spacing(0, 1)
      }
    }),
    wrapper: css({
      width: "100%",
      display: "flex",
      justifyContent: "space-between",
      alignItems: "baseline"
    }),
    title: css({
      flexGrow: 1,
      overflow: "hidden",
      fontSize: theme.typography.bodySmall.fontSize,
      fontWeight: theme.typography.fontWeightMedium,
      margin: 0
    }),
    description: css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.bodySmall.fontSize,
      fontWeight: theme.typography.bodySmall.fontWeight,
      paddingLeft: theme.spacing(2),
      gap: theme.spacing(2),
      display: "flex"
    }),
    body: css({
      display: "flex",
      gap: theme.spacing(2),
      flexWrap: "wrap"
    }),
    tooltip: css({
      marginRight: theme.spacing(0.25)
    })
  };
};

export { QueryOptionGroup };
//# sourceMappingURL=QueryOptionGroup.mjs.map
