import { userHasPermission, userHasPermissionInMetadata, userHasAllPermissions, userHasAnyPermission } from '@grafana/data';
import { getCurrentUser } from '../services/user.mjs';

"use strict";
const hasPermission = (action) => userHasPermission(action, getCurrentUser());
const hasPermissionInMetadata = (action, object) => userHasPermissionInMetadata(action, object);
const hasAllPermissions = (actions) => userHasAllPermissions(actions, getCurrentUser());
const hasAnyPermission = (actions) => userHasAnyPermission(actions, getCurrentUser());

export { hasAllPermissions, hasAnyPermission, hasPermission, hasPermissionInMetadata };
//# sourceMappingURL=rbac.mjs.map
