'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var jsxRuntime = require('react/jsx-runtime');
var i18n = require('i18next');
var LanguageDetector = require('i18next-browser-languagedetector');
var reactI18next = require('react-i18next');
var deepEqual = require('fast-deep-equal');
var memoize = require('micro-memoize');

function _interopDefaultCompat (e) { return e && typeof e === 'object' && 'default' in e ? e : { default: e }; }

var i18n__default = /*#__PURE__*/_interopDefaultCompat(i18n);
var LanguageDetector__default = /*#__PURE__*/_interopDefaultCompat(LanguageDetector);
var deepEqual__default = /*#__PURE__*/_interopDefaultCompat(deepEqual);
var memoize__default = /*#__PURE__*/_interopDefaultCompat(memoize);

"use strict";
const ENGLISH_US = "en-US";
const FRENCH_FRANCE = "fr-FR";
const SPANISH_SPAIN = "es-ES";
const GERMAN_GERMANY = "de-DE";
const BRAZILIAN_PORTUGUESE = "pt-BR";
const CHINESE_SIMPLIFIED = "zh-Hans";
const ITALIAN_ITALY = "it-IT";
const JAPANESE_JAPAN = "ja-JP";
const INDONESIAN_INDONESIA = "id-ID";
const KOREAN_KOREA = "ko-KR";
const RUSSIAN_RUSSIA = "ru-RU";
const CZECH_CZECHIA = "cs-CZ";
const DUTCH_NETHERLANDS = "nl-NL";
const HUNGARIAN_HUNGARY = "hu-HU";
const PORTUGUESE_PORTUGAL = "pt-PT";
const POLISH_POLAND = "pl-PL";
const SWEDISH_SWEDEN = "sv-SE";
const TURKISH_TURKEY = "tr-TR";
const CHINESE_TRADITIONAL = "zh-Hant";
const DEFAULT_LANGUAGE = ENGLISH_US;
const PSEUDO_LOCALE = "pseudo";

"use strict";
const LANGUAGES = [
  { code: ENGLISH_US, name: "English" },
  { code: FRENCH_FRANCE, name: "Fran\xE7ais" },
  { code: SPANISH_SPAIN, name: "Espa\xF1ol" },
  { code: GERMAN_GERMANY, name: "Deutsch" },
  { code: CHINESE_SIMPLIFIED, name: "\u4E2D\u6587\uFF08\u7B80\u4F53\uFF09" },
  { code: BRAZILIAN_PORTUGUESE, name: "Portugu\xEAs Brasileiro" },
  { code: CHINESE_TRADITIONAL, name: "\u4E2D\u6587\uFF08\u7E41\u9AD4\uFF09" },
  { code: ITALIAN_ITALY, name: "Italiano" },
  { code: JAPANESE_JAPAN, name: "\u65E5\u672C\u8A9E" },
  { code: INDONESIAN_INDONESIA, name: "Bahasa Indonesia" },
  { code: KOREAN_KOREA, name: "\uD55C\uAD6D\uC5B4" },
  { code: RUSSIAN_RUSSIA, name: "\u0420\u0443\u0441\u0441\u043A\u0438\u0439" },
  { code: CZECH_CZECHIA, name: "\u010Ce\u0161tina" },
  { code: DUTCH_NETHERLANDS, name: "Nederlands" },
  { code: HUNGARIAN_HUNGARY, name: "Magyar" },
  { code: PORTUGUESE_PORTUGAL, name: "Portugu\xEAs" },
  { code: POLISH_POLAND, name: "Polski" },
  { code: SWEDISH_SWEDEN, name: "Svenska" },
  { code: TURKISH_TURKEY, name: "T\xFCrk\xE7e" }
];

"use strict";
const deepMemoize = (fn) => memoize__default.default(fn, { isEqual: deepEqual__default.default });
let regionalFormat;
const createDateTimeFormatter = deepMemoize((locale, options) => {
  return new Intl.DateTimeFormat(locale, options);
});
const createDurationFormatter = deepMemoize((locale, options) => {
  return new Intl.DurationFormat(locale, options);
});
const formatDate = deepMemoize(
  (_value, format = {}) => {
    const value = typeof _value === "string" ? new Date(_value) : _value;
    const dateFormatter = createDateTimeFormatter(regionalFormat, format);
    return dateFormatter.format(value);
  }
);
const formatDuration = deepMemoize(
  (duration, options = {}) => {
    const dateFormatter = createDurationFormatter(regionalFormat, options);
    return dateFormatter.format(duration);
  }
);
const formatDateRange = (_from, _to, format = {}) => {
  const from = typeof _from === "string" ? new Date(_from) : _from;
  const to = typeof _to === "string" ? new Date(_to) : _to;
  const dateFormatter = createDateTimeFormatter(regionalFormat, format);
  return dateFormatter.formatRange(from, to);
};
const initRegionalFormat = (regionalFormatArg) => {
  regionalFormat = regionalFormatArg;
};

"use strict";
let tFunc;
let transComponent;
const VALID_LANGUAGES = [
  ...LANGUAGES,
  {
    name: "Pseudo",
    code: PSEUDO_LOCALE
  }
];
function initTFuncAndTransComponent({ id, ns } = {}) {
  if (id) {
    tFunc = getI18nInstance().getFixedT(null, id);
    transComponent = (props) => /* @__PURE__ */ jsxRuntime.jsx(reactI18next.Trans, { shouldUnescape: true, ns: id, ...props });
    return;
  }
  tFunc = getI18nInstance().t;
  transComponent = (props) => /* @__PURE__ */ jsxRuntime.jsx(reactI18next.Trans, { shouldUnescape: true, ns, ...props });
}
async function loadNamespacedResources(namespace, language, loaders) {
  if (!(loaders == null ? void 0 : loaders.length)) {
    return;
  }
  const resolvedLanguage = language === PSEUDO_LOCALE ? DEFAULT_LANGUAGE : language;
  return Promise.all(
    loaders.map(async (loader) => {
      try {
        const resources = await loader(resolvedLanguage);
        addResourceBundle(resolvedLanguage, namespace, resources);
      } catch (error) {
        console.error(`Error loading resources for namespace ${namespace} and language: ${resolvedLanguage}`, error);
      }
    })
  );
}
function initDefaultI18nInstance() {
  var _a;
  if (((_a = getI18nInstance().options) == null ? void 0 : _a.resources) && typeof getI18nInstance().options.resources === "object") {
    return;
  }
  const initPromise = getI18nInstance().use(reactI18next.initReactI18next).init({
    resources: {},
    returnEmptyString: false,
    lng: DEFAULT_LANGUAGE
    // this should be the locale of the phrases in our source JSX
  });
  initTFuncAndTransComponent();
  return initPromise;
}
function initDefaultReactI18nInstance() {
  var _a, _b;
  if ((_b = (_a = reactI18next.getI18n()) == null ? void 0 : _a.options) == null ? void 0 : _b.react) {
    return;
  }
  const options = {};
  reactI18next.setDefaults(options);
  reactI18next.setI18n(getI18nInstance());
}
async function initPluginTranslations(id, loaders) {
  await initDefaultI18nInstance();
  initDefaultReactI18nInstance();
  const language = getResolvedLanguage();
  initTFuncAndTransComponent({ id });
  await loadNamespacedResources(id, language, loaders);
  return { language };
}
function getI18nInstance() {
  return i18n__default.default;
}
async function initTranslations({
  ns,
  language = DEFAULT_LANGUAGE,
  module
}) {
  var _a, _b;
  const options = {
    // We don't bundle any translations, we load them async
    partialBundledLanguages: true,
    resources: {},
    // If translations are empty strings (no translation), fall back to the default value in source code
    returnEmptyString: false,
    // Required to ensure that `resolvedLanguage` is set property when an invalid language is passed (such as through 'detect')
    supportedLngs: VALID_LANGUAGES.map((lang) => lang.code),
    fallbackLng: DEFAULT_LANGUAGE,
    ns,
    postProcess: [
      // Add pseudo processing even if we aren't necessarily going to use it
      PSEUDO_LOCALE
    ]
  };
  if (language === "detect") {
    getI18nInstance().use(LanguageDetector__default.default);
    const detection = { order: ["navigator"], caches: [] };
    options.detection = detection;
  } else {
    options.lng = (_b = (_a = VALID_LANGUAGES.find((lang) => lang.code === language)) == null ? void 0 : _a.code) != null ? _b : void 0;
  }
  if (module) {
    getI18nInstance().use(module).use(reactI18next.initReactI18next);
  } else {
    getI18nInstance().use(reactI18next.initReactI18next);
  }
  if (language === PSEUDO_LOCALE) {
    const { default: Pseudo } = await import('i18next-pseudo');
    getI18nInstance().use(
      new Pseudo({
        languageToPseudo: PSEUDO_LOCALE,
        enabled: true,
        wrapped: true
      })
    );
  }
  await getI18nInstance().init(options);
  initTFuncAndTransComponent({ ns });
  return {
    language: getResolvedLanguage()
  };
}
function getLanguage() {
  var _a;
  return ((_a = getI18nInstance()) == null ? void 0 : _a.language) || DEFAULT_LANGUAGE;
}
function getResolvedLanguage() {
  var _a;
  return ((_a = getI18nInstance()) == null ? void 0 : _a.resolvedLanguage) || DEFAULT_LANGUAGE;
}
function getNamespaces() {
  var _a;
  return (_a = getI18nInstance()) == null ? void 0 : _a.options.ns;
}
async function changeLanguage(language) {
  var _a, _b;
  const validLanguage = (_b = (_a = VALID_LANGUAGES.find((lang) => lang.code === language)) == null ? void 0 : _a.code) != null ? _b : DEFAULT_LANGUAGE;
  await getI18nInstance().changeLanguage(validLanguage);
}
async function initializeI18n({ language, ns, module }, regionalFormat) {
  initRegionalFormat(regionalFormat);
  return initTranslations({ language, ns, module });
}
function addResourceBundle(language, namespace, resources) {
  getI18nInstance().addResourceBundle(language, namespace, resources, true, false);
}
const t = (id, defaultMessage, values) => {
  initDefaultI18nInstance();
  if (!tFunc) {
    if (process.env.NODE_ENV !== "test") {
      console.warn(
        "t() was called before i18n was initialized. This is probably caused by calling t() in the root module scope, instead of lazily on render"
      );
    }
    if (process.env.NODE_ENV === "development") {
      throw new Error("t() was called before i18n was initialized");
    }
    tFunc = getI18nInstance().t;
  }
  return tFunc(id, defaultMessage, values);
};
function Trans(props) {
  initDefaultI18nInstance();
  const Component = transComponent != null ? transComponent : reactI18next.Trans;
  return /* @__PURE__ */ jsxRuntime.jsx(Component, { shouldUnescape: true, ...props });
}

"use strict";

exports.BRAZILIAN_PORTUGUESE = BRAZILIAN_PORTUGUESE;
exports.CHINESE_SIMPLIFIED = CHINESE_SIMPLIFIED;
exports.CHINESE_TRADITIONAL = CHINESE_TRADITIONAL;
exports.CZECH_CZECHIA = CZECH_CZECHIA;
exports.DEFAULT_LANGUAGE = DEFAULT_LANGUAGE;
exports.DUTCH_NETHERLANDS = DUTCH_NETHERLANDS;
exports.ENGLISH_US = ENGLISH_US;
exports.FRENCH_FRANCE = FRENCH_FRANCE;
exports.GERMAN_GERMANY = GERMAN_GERMANY;
exports.HUNGARIAN_HUNGARY = HUNGARIAN_HUNGARY;
exports.INDONESIAN_INDONESIA = INDONESIAN_INDONESIA;
exports.ITALIAN_ITALY = ITALIAN_ITALY;
exports.JAPANESE_JAPAN = JAPANESE_JAPAN;
exports.KOREAN_KOREA = KOREAN_KOREA;
exports.LANGUAGES = LANGUAGES;
exports.POLISH_POLAND = POLISH_POLAND;
exports.PORTUGUESE_PORTUGAL = PORTUGUESE_PORTUGAL;
exports.PSEUDO_LOCALE = PSEUDO_LOCALE;
exports.RUSSIAN_RUSSIA = RUSSIAN_RUSSIA;
exports.SPANISH_SPAIN = SPANISH_SPAIN;
exports.SWEDISH_SWEDEN = SWEDISH_SWEDEN;
exports.TURKISH_TURKEY = TURKISH_TURKEY;
exports.Trans = Trans;
exports.formatDate = formatDate;
exports.formatDateRange = formatDateRange;
exports.formatDuration = formatDuration;
exports.initPluginTranslations = initPluginTranslations;
exports.t = t;
//# sourceMappingURL=index.cjs.map
