import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { omit } from 'lodash';
import { Trans } from '@grafana/i18n';
import { Button } from '../Button/Button.mjs';
import { FormField } from '../FormField/FormField.mjs';

"use strict";
const SecretFormField = ({
  label = "Password",
  labelWidth,
  inputWidth = 12,
  onReset,
  isConfigured,
  tooltip,
  placeholder = "Password",
  interactive,
  ...inputProps
}) => {
  return /* @__PURE__ */ jsx(
    FormField,
    {
      label,
      tooltip,
      interactive,
      labelWidth,
      inputEl: isConfigured ? /* @__PURE__ */ jsxs(Fragment, { children: [
        /* @__PURE__ */ jsx(
          "input",
          {
            type: "text",
            className: `gf-form-input width-${inputWidth}`,
            disabled: true,
            value: "configured",
            ...omit(inputProps, "value")
          }
        ),
        /* @__PURE__ */ jsx(Button, { onClick: onReset, variant: "secondary", type: "button", children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.secret-form-field.reset", children: "Reset" }) })
      ] }) : /* @__PURE__ */ jsx(
        "input",
        {
          type: "password",
          className: `gf-form-input width-${inputWidth}`,
          placeholder,
          ...inputProps
        }
      )
    }
  );
};
SecretFormField.displayName = "SecretFormField";

export { SecretFormField };
//# sourceMappingURL=SecretFormField.mjs.map
