import { useState, useEffect } from 'react';
import { useMeasure } from 'react-use';
import { measureText } from '../../utils/measureText.mjs';

"use strict";
const FONT_SIZE = 12;
const EXTRA_PILL_SIZE = 50;
const EXTRA_PILL_DISABLED_SIZE = 10;
const MAX_SHOWN_ITEMS = 15;
function useMeasureMulti(selectedItems, width, disabled) {
  const [shownItems, setShownItems] = useState(selectedItems.length);
  const [measureRef, { width: containerWidth }] = useMeasure();
  const [counterMeasureRef, { width: counterWidth }] = useMeasure();
  const [suffixMeasureRef, { width: suffixWidth }] = useMeasure();
  const finalWidth = width && width !== "auto" ? width : containerWidth;
  useEffect(() => {
    const maxWidth = finalWidth - counterWidth - suffixWidth;
    let currWidth = 0;
    for (let i = 0; i < selectedItems.length; i++) {
      currWidth += measureText(selectedItems[i].label || "", FONT_SIZE).width + (disabled ? EXTRA_PILL_DISABLED_SIZE : EXTRA_PILL_SIZE);
      if (currWidth > maxWidth) {
        setShownItems(Math.min(i, MAX_SHOWN_ITEMS) || 1);
        break;
      }
      if (i === selectedItems.length - 1) {
        setShownItems(selectedItems.length);
      }
    }
  }, [finalWidth, counterWidth, suffixWidth, selectedItems, setShownItems, disabled]);
  return { measureRef, counterMeasureRef, suffixMeasureRef, shownItems };
}

export { MAX_SHOWN_ITEMS, useMeasureMulti };
//# sourceMappingURL=useMeasureMulti.mjs.map
