import { jsxs, jsx } from 'react/jsx-runtime';
import { Trans } from '@grafana/i18n';
import { Icon } from '../Icon/Icon.mjs';
import { Box } from '../Layout/Box/Box.mjs';
import { Stack } from '../Layout/Stack/Stack.mjs';
import { Text } from '../Text/Text.mjs';

"use strict";
const AsyncError = () => /* @__PURE__ */ jsxs(MessageRow, { children: [
  /* @__PURE__ */ jsx(Text, { color: "warning", children: /* @__PURE__ */ jsx(Icon, { name: "exclamation-triangle", size: "md" }) }),
  /* @__PURE__ */ jsx(Trans, { i18nKey: "combobox.async.error", children: "An error occurred while loading options." })
] });
const NotFoundError = () => /* @__PURE__ */ jsx(MessageRow, { children: /* @__PURE__ */ jsx(Trans, { i18nKey: "combobox.options.no-found", children: "No options found." }) });
const MessageRow = ({ children }) => {
  return /* @__PURE__ */ jsx(Box, { padding: 2, children: /* @__PURE__ */ jsx(Stack, { justifyContent: "center", alignItems: "center", direction: "column", children }) });
};

export { AsyncError, NotFoundError };
//# sourceMappingURL=MessageRows.mjs.map
