'use strict';

var jsxRuntime = require('react/jsx-runtime');
var Editor = require('@monaco-editor/react');
var monaco = require('monaco-editor');
var React = require('react');
var unstable = require('./unstable-DEjn5gC8.js');
var tinycolor = require('tinycolor2');
require('@emotion/css');
require('react-data-grid/lib/styles.css');
require('react-data-grid');
require('@grafana/data');
require('@grafana/i18n');
require('@grafana/schema');
require('hoist-non-react-statics');
require('micro-memoize');
require('react-use');
require('@grafana/e2e-selectors');
require('lodash');
require('react-inlinesvg');
require('react-dom');
require('@floating-ui/react');
require('react-dom/server');
require('react-transition-group');
require('@react-aria/dialog');
require('@react-aria/focus');
require('@react-aria/overlays');
require('react-hook-form');
require('rc-drawer');
require('rc-drawer/assets/index.css');
require('react-window');
require('ol/format');
require('ol/geom');
require('uwrap');
require('ol/format/WKT');
require('uplot');
require('uplot/dist/uPlot.min.css');

function _interopDefaultCompat (e) { return e && typeof e === 'object' && 'default' in e ? e : { default: e }; }

function _interopNamespaceCompat(e) {
  if (e && typeof e === 'object' && 'default' in e) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var Editor__default = /*#__PURE__*/_interopDefaultCompat(Editor);
var monaco__namespace = /*#__PURE__*/_interopNamespaceCompat(monaco);
var tinycolor__default = /*#__PURE__*/_interopDefaultCompat(tinycolor);

"use strict";
function getColors(theme) {
  if (theme === void 0) {
    return {};
  } else {
    const colors = {
      "editor.background": theme.components.input.background,
      "minimap.background": theme.colors.background.secondary
    };
    Object.keys(colors).forEach((resultKey) => {
      colors[resultKey] = normalizeColorForMonaco(colors[resultKey]);
    });
    return colors;
  }
}
function normalizeColorForMonaco(color) {
  return tinycolor__default.default(color).toHexString();
}
function defineThemes(monaco, theme) {
  const colors = getColors(theme);
  monaco.editor.defineTheme("grafana-dark", {
    base: "vs-dark",
    inherit: true,
    colors,
    // fallback syntax highlighting for languages that microsoft doesn't handle (ex cloudwatch's metric math)
    rules: [
      { token: "predefined", foreground: normalizeColorForMonaco(theme == null ? void 0 : theme.visualization.getColorByName("purple")) },
      { token: "operator", foreground: normalizeColorForMonaco(theme == null ? void 0 : theme.visualization.getColorByName("orange")) },
      { token: "tag", foreground: normalizeColorForMonaco(theme == null ? void 0 : theme.visualization.getColorByName("green")) }
    ]
  });
  monaco.editor.defineTheme("grafana-light", {
    base: "vs",
    inherit: true,
    colors,
    // fallback syntax highlighting for languages that microsoft doesn't handle (ex cloudwatch's metric math)
    rules: [
      { token: "predefined", foreground: normalizeColorForMonaco(theme == null ? void 0 : theme.visualization.getColorByName("purple")) },
      { token: "operator", foreground: normalizeColorForMonaco(theme == null ? void 0 : theme.visualization.getColorByName("orange")) },
      { token: "tag", foreground: normalizeColorForMonaco(theme == null ? void 0 : theme.visualization.getColorByName("green")) }
    ]
  });
}

"use strict";
Editor.loader.config({ monaco: monaco__namespace });
const ReactMonacoEditor = (props) => {
  const { beforeMount, onMount, options, ...restProps } = props;
  const theme = unstable.useTheme2();
  const onMonacoBeforeMount = React.useCallback(
    (monaco2) => {
      beforeMount == null ? void 0 : beforeMount(monaco2);
    },
    [beforeMount]
  );
  React.useEffect(() => {
    defineThemes(monaco__namespace, theme);
  }, [theme]);
  return /* @__PURE__ */ jsxRuntime.jsx(
    Editor__default.default,
    {
      ...restProps,
      options: {
        ...options,
        fontFamily: theme.typography.code.fontFamily
      },
      theme: theme.isDark ? "grafana-dark" : "grafana-light",
      beforeMount: onMonacoBeforeMount,
      onMount: (editor, monaco2) => {
        document.fonts.ready.then(() => {
          monaco2.editor.remeasureFonts();
        });
        onMount == null ? void 0 : onMount(editor, monaco2);
      }
    }
  );
};

exports.ReactMonacoEditor = ReactMonacoEditor;
//# sourceMappingURL=ReactMonacoEditor-DvII_baG.js.map
