"use strict";
let singletonInstance = null;
function setCurrentUser(instance) {
  if (singletonInstance) {
    throw new Error("User should only be set once, when Grafana is starting.");
  }
  singletonInstance = instance;
}
function getCurrentUser() {
  if (!singletonInstance) {
    throw new Error("User can only be used after Grafana instance has started.");
  }
  return singletonInstance;
}

export { getCurrentUser, setCurrentUser };
//# sourceMappingURL=user.mjs.map
