import { jsx } from 'react/jsx-runtime';
import { t } from '@grafana/i18n';
import { RadioButtonGroup } from '@grafana/ui';
import { QueryEditorMode } from './types.mjs';

"use strict";
function QueryEditorModeToggle({ mode, onChange }) {
  const editorModes = [
    {
      label: t("grafana-prometheus.querybuilder.query-editor-mode-toggle.editor-modes.label-builder", "Builder"),
      value: QueryEditorMode.Builder
    },
    {
      label: t("grafana-prometheus.querybuilder.query-editor-mode-toggle.editor-modes.label-code", "Code"),
      value: QueryEditorMode.Code
    }
  ];
  return /* @__PURE__ */ jsx("div", { "data-testid": "QueryEditorModeToggle", children: /* @__PURE__ */ jsx(RadioButtonGroup, { options: editorModes, size: "sm", value: mode, onChange }) });
}

export { QueryEditorModeToggle };
//# sourceMappingURL=QueryEditorModeToggle.mjs.map
