import { jsxs, jsx } from 'react/jsx-runtime';
import { useStyles2, Stack } from '@grafana/ui';
import { LabelSelector } from './LabelSelector.mjs';
import { MetricSelector } from './MetricSelector.mjs';
import { SelectorActions } from './SelectorActions.mjs';
import { ValueSelector } from './ValueSelector.mjs';
import { getStylesMetricsBrowser } from './styles.mjs';

"use strict";
const MetricsBrowser = () => {
  const styles = useStyles2(getStylesMetricsBrowser);
  return /* @__PURE__ */ jsxs("div", { className: styles.wrapper, children: [
    /* @__PURE__ */ jsxs(Stack, { gap: 3, children: [
      /* @__PURE__ */ jsx(MetricSelector, {}),
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx(LabelSelector, {}),
        /* @__PURE__ */ jsx(ValueSelector, {})
      ] })
    ] }),
    /* @__PURE__ */ jsx(SelectorActions, {})
  ] });
};

export { MetricsBrowser };
//# sourceMappingURL=MetricsBrowser.mjs.map
